/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.registry.io.xpp3;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.archetype.registry.ArchetypeRegistry;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class ArchetypeRegistryXpp3Writer {
    private String NAMESPACE;

    public void write(Writer writer, ArchetypeRegistry archetypeRegistry) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(archetypeRegistry.getModelEncoding(), null);
        this.writeArchetypeRegistry(archetypeRegistry, "archetype-registry", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeArchetypeRegistry(ArchetypeRegistry archetypeRegistry, String tagName, XmlSerializer serializer) throws IOException {
        if (archetypeRegistry != null) {
            Iterator iter;
            serializer.startTag(this.NAMESPACE, tagName);
            if (archetypeRegistry.getLanguages() != null && archetypeRegistry.getLanguages().size() > 0) {
                serializer.startTag(this.NAMESPACE, "Languages");
                iter = archetypeRegistry.getLanguages().iterator();
                while (iter.hasNext()) {
                    String language = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "Language").text(language).endTag(this.NAMESPACE, "Language");
                }
                serializer.endTag(this.NAMESPACE, "Languages");
            }
            if (archetypeRegistry.getFilteredExtensions() != null && archetypeRegistry.getFilteredExtensions().size() > 0) {
                serializer.startTag(this.NAMESPACE, "FilteredExtensions");
                iter = archetypeRegistry.getFilteredExtensions().iterator();
                while (iter.hasNext()) {
                    String filteredExtension = (String)iter.next();
                    serializer.startTag(this.NAMESPACE, "FilteredExtension").text(filteredExtension).endTag(this.NAMESPACE, "FilteredExtension");
                }
                serializer.endTag(this.NAMESPACE, "FilteredExtensions");
            }
            serializer.endTag(this.NAMESPACE, tagName);
        }
    }
}

