/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.tasks.Comment;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.actions.BaseTaskAction;
import com.intellij.tasks.actions.ChooseStacktraceDialog;
import com.intellij.unscramble.AnalyzeStacktraceUtil;

public class AnalyzeTaskStacktraceAction
extends BaseTaskAction {
    public void actionPerformed(AnActionEvent e) {
        LocalTask activeTask = AnalyzeTaskStacktraceAction.getActiveTask(e);
        Project project = AnalyzeTaskStacktraceAction.getProject(e);
        assert (activeTask != null);
        assert (project != null);
        AnalyzeTaskStacktraceAction.analyzeStacktrace((Task)activeTask, project);
    }

    @Override
    public void update(AnActionEvent event) {
        super.update(event);
        if (event.getPresentation().isEnabled()) {
            LocalTask activeTask = AnalyzeTaskStacktraceAction.getActiveTask(event);
            event.getPresentation().setEnabled(activeTask != null && AnalyzeTaskStacktraceAction.hasTexts((Task)activeTask));
        }
    }

    public static boolean hasTexts(Task activeTask) {
        return activeTask.getDescription() != null || activeTask.getComments().length > 0;
    }

    public static void analyzeStacktrace(Task task, Project project) {
        ChooseStacktraceDialog stacktraceDialog = new ChooseStacktraceDialog(project, task);
        if (stacktraceDialog.showAndGet() && stacktraceDialog.getTraces().length > 0) {
            Comment[] comments;
            for (Comment comment : comments = stacktraceDialog.getTraces()) {
                AnalyzeStacktraceUtil.addConsole((Project)project, null, (String)task.getId(), (String)comment.getText());
            }
        }
    }
}

