/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.playback.commands.ActionCommand;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.MultiSelectionListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.tasks.ChangeListInfo;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.actions.BaseTaskAction;
import com.intellij.tasks.actions.EditTaskDialog;
import com.intellij.tasks.actions.GotoTaskAction;
import com.intellij.tasks.actions.TaskListItem;
import com.intellij.tasks.impl.LocalTaskImpl;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.tools.SimpleActionGroup;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchTaskAction
extends BaseTaskAction {
    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        assert (project != null);
        ListPopupImpl popup = SwitchTaskAction.createPopup(dataContext, null, true);
        popup.showCenteredInCurrentWindow(project);
    }

    public static ListPopupImpl createPopup(DataContext dataContext, final @Nullable Runnable onDispose, boolean withTitle) {
        final Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        final Ref shiftPressed = Ref.create((Object)false);
        final Ref componentRef = Ref.create();
        List items = project == null ? Collections.emptyList() : SwitchTaskAction.createPopupActionGroup(project, (Ref<Boolean>)shiftPressed, (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext));
        String title = withTitle ? "Switch to Task" : null;
        MultiSelectionListPopupStep<TaskListItem> step = new MultiSelectionListPopupStep<TaskListItem>(title, items){

            public PopupStep<?> onChosen(List<TaskListItem> selectedValues, boolean finalChoice) {
                if (finalChoice) {
                    selectedValues.get(0).select();
                    return FINAL_CHOICE;
                }
                ActionGroup group = SwitchTaskAction.createActionsStep(selectedValues, project, (Ref<Boolean>)shiftPressed);
                return JBPopupFactory.getInstance().createActionsStep(group, DataManager.getInstance().getDataContext((Component)componentRef.get()), false, false, null, null, true);
            }

            public Icon getIconFor(TaskListItem aValue) {
                return aValue.getIcon();
            }

            @NotNull
            public String getTextFor(TaskListItem value) {
                String string = value.getText();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/actions/SwitchTaskAction$1", "getTextFor"));
                }
                return string;
            }

            @Nullable
            public ListSeparator getSeparatorAbove(TaskListItem value) {
                return value.getSeparator() == null ? null : new ListSeparator(value.getSeparator());
            }

            public boolean hasSubstep(List<TaskListItem> selectedValues) {
                return selectedValues.size() > 1 || selectedValues.get(0).getTask() != null;
            }
        };
        final ListPopupImpl popup = (ListPopupImpl)JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        if (onDispose != null) {
            Disposer.register((Disposable)popup, (Disposable)new Disposable(){

                public void dispose() {
                    onDispose.run();
                }
            });
        }
        componentRef.set((Object)popup.getComponent());
        if (items.size() <= 2) {
            return popup;
        }
        popup.setAdText("Press SHIFT to merge with current context");
        popup.registerAction("shiftPressed", KeyStroke.getKeyStroke("shift pressed SHIFT"), (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                shiftPressed.set((Object)true);
                popup.setCaption("Merge with Current Context");
            }
        });
        popup.registerAction("shiftReleased", KeyStroke.getKeyStroke("released SHIFT"), (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                shiftPressed.set((Object)false);
                popup.setCaption("Switch to Task");
            }
        });
        popup.registerAction("invoke", KeyStroke.getKeyStroke("shift ENTER"), (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                popup.handleSelect(true);
            }
        });
        return popup;
    }

    private static ActionGroup createActionsStep(final List<TaskListItem> tasks, final Project project, final Ref<Boolean> shiftPressed) {
        SimpleActionGroup group = new SimpleActionGroup();
        final TaskManager manager = TaskManager.getManager((Project)project);
        final LocalTask task = tasks.get(0).getTask();
        if (tasks.size() == 1 && task != null) {
            group.add(new AnAction("&Switch to"){

                public void actionPerformed(AnActionEvent e) {
                    manager.activateTask((Task)task, (Boolean)shiftPressed.get() == false);
                }
            });
            group.add(new AnAction("&Edit"){

                public void actionPerformed(AnActionEvent e) {
                    EditTaskDialog.editTask((LocalTaskImpl)task, project);
                }
            });
        }
        AnAction remove = new AnAction("&Remove"){

            public void actionPerformed(AnActionEvent e) {
                for (TaskListItem item : tasks) {
                    LocalTask itemTask = item.getTask();
                    if (itemTask == null) continue;
                    SwitchTaskAction.removeTask(project, itemTask, manager);
                }
            }
        };
        remove.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(127, 0)), null);
        group.add(remove);
        return group;
    }

    @NotNull
    private static List<TaskListItem> createPopupActionGroup(@NotNull Project project, final Ref<Boolean> shiftPressed, final Component contextComponent) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tasks/actions/SwitchTaskAction", "createPopupActionGroup"));
        }
        ArrayList<TaskListItem> group = new ArrayList<TaskListItem>();
        AnAction action = ActionManager.getInstance().getAction("tasks.goto");
        assert (action instanceof GotoTaskAction);
        final GotoTaskAction gotoTaskAction = (GotoTaskAction)action;
        group.add(new TaskListItem(gotoTaskAction.getTemplatePresentation().getText(), gotoTaskAction.getTemplatePresentation().getIcon()){

            @Override
            void select() {
                ActionManager.getInstance().tryToExecute((AnAction)gotoTaskAction, ActionCommand.getInputEvent((String)"tasks.goto"), contextComponent, "unknown", false);
            }
        });
        final TaskManager manager = TaskManager.getManager((Project)project);
        LocalTask activeTask = manager.getActiveTask();
        List localTasks = manager.getLocalTasks();
        Collections.sort(localTasks, TaskManagerImpl.TASK_UPDATE_COMPARATOR);
        ArrayList<LocalTask> temp = new ArrayList<LocalTask>();
        for (final LocalTask task : localTasks) {
            if (task == activeTask) continue;
            if (manager.isLocallyClosed(task)) {
                temp.add(task);
                continue;
            }
            group.add(new TaskListItem(task, group.size() == 1 ? "" : null, false){

                @Override
                void select() {
                    manager.activateTask((Task)task, (Boolean)shiftPressed.get() == false);
                }
            });
        }
        if (!temp.isEmpty()) {
            int tempSize = temp.size();
            for (int i = 0; i < Math.min(tempSize, 15); ++i) {
                final LocalTask task = (LocalTask)temp.get(i);
                group.add(new TaskListItem(task, i == 0 ? "Recently Closed Tasks" : null, true){

                    @Override
                    void select() {
                        manager.activateTask((Task)task, (Boolean)shiftPressed.get() == false);
                    }
                });
            }
        }
        ArrayList<TaskListItem> arrayList = group;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/actions/SwitchTaskAction", "createPopupActionGroup"));
        }
        return arrayList;
    }

    public static void removeTask(final @NotNull Project project, LocalTask task, TaskManager manager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/tasks/actions/SwitchTaskAction", "removeTask"));
        }
        if (task.isDefault()) {
            Messages.showInfoMessage((Project)project, (String)"Default task cannot be removed", (String)"Cannot Remove");
        } else {
            List infos = task.getChangeLists();
            List lists = ContainerUtil.mapNotNull((Collection)infos, (Function)new NullableFunction<ChangeListInfo, LocalChangeList>(){

                public LocalChangeList fun(ChangeListInfo changeListInfo) {
                    LocalChangeList changeList = ChangeListManager.getInstance((Project)project).getChangeList(changeListInfo.id);
                    return changeList != null && !changeList.isDefault() ? changeList : null;
                }
            });
            boolean removeIt = true;
            block4: for (LocalChangeList list : lists) {
                if (list.getChanges().isEmpty()) continue;
                int result = Messages.showYesNoCancelDialog((Project)project, (String)("Changelist associated with '" + task.getSummary() + "' is not empty.\n" + "Do you want to remove it and move the changes to the active changelist?"), (String)"Changelist Not Empty", (Icon)Messages.getWarningIcon());
                switch (result) {
                    case 0: {
                        break block4;
                    }
                    case 1: {
                        removeIt = false;
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (removeIt) {
                for (LocalChangeList list : lists) {
                    ChangeListManager.getInstance((Project)project).removeChangeList(list);
                }
            }
            manager.removeTask(task);
        }
    }
}

