/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshotRepository;
import org.gradle.api.internal.changedetection.state.InputPropertiesSerializer;
import org.gradle.api.internal.changedetection.state.TaskArtifactStateCacheAccess;
import org.gradle.api.internal.changedetection.state.TaskExecution;
import org.gradle.api.internal.changedetection.state.TaskHistoryRepository;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.internal.Factory;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheBackedTaskHistoryRepository
implements TaskHistoryRepository {
    private final TaskArtifactStateCacheAccess cacheAccess;
    private final FileSnapshotRepository snapshotRepository;
    private final PersistentIndexedCache<String, TaskHistory> taskHistoryCache;
    private final TaskHistorySerializer serializer;
    private final StringInterner stringInterner;

    public CacheBackedTaskHistoryRepository(TaskArtifactStateCacheAccess cacheAccess, FileSnapshotRepository snapshotRepository, StringInterner stringInterner) {
        this.cacheAccess = cacheAccess;
        this.snapshotRepository = snapshotRepository;
        this.stringInterner = stringInterner;
        this.serializer = new TaskHistorySerializer(stringInterner);
        this.taskHistoryCache = cacheAccess.createCache("taskArtifacts", String.class, this.serializer);
    }

    @Override
    public TaskHistoryRepository.History getHistory(final TaskInternal task) {
        final TaskHistory history = this.loadHistory(task);
        final LazyTaskExecution currentExecution = new LazyTaskExecution();
        currentExecution.snapshotRepository = this.snapshotRepository;
        currentExecution.cacheAccess = this.cacheAccess;
        currentExecution.setOutputFiles(this.outputFiles(task));
        final LazyTaskExecution previousExecution = this.findPreviousExecution(currentExecution, history);
        if (previousExecution != null) {
            previousExecution.snapshotRepository = this.snapshotRepository;
            previousExecution.cacheAccess = this.cacheAccess;
        }
        return new TaskHistoryRepository.History(){

            public TaskExecution getPreviousExecution() {
                return previousExecution;
            }

            public TaskExecution getCurrentExecution() {
                return currentExecution;
            }

            public void update() {
                CacheBackedTaskHistoryRepository.this.cacheAccess.useCache("Update task history", new Runnable(){

                    public void run() {
                        history.configurations.add(0, currentExecution);
                        if (currentExecution.inputFilesSnapshotId == null && currentExecution.inputFilesSnapshot != null) {
                            currentExecution.inputFilesSnapshotId = CacheBackedTaskHistoryRepository.this.snapshotRepository.add(currentExecution.inputFilesSnapshot);
                        }
                        if (currentExecution.outputFilesSnapshotId == null && currentExecution.outputFilesSnapshot != null) {
                            currentExecution.outputFilesSnapshotId = CacheBackedTaskHistoryRepository.this.snapshotRepository.add(currentExecution.outputFilesSnapshot);
                        }
                        if (currentExecution.discoveredFilesSnapshotId == null && currentExecution.discoveredFilesSnapshot != null) {
                            currentExecution.discoveredFilesSnapshotId = CacheBackedTaskHistoryRepository.this.snapshotRepository.add(currentExecution.discoveredFilesSnapshot);
                        }
                        while (history.configurations.size() > 3) {
                            LazyTaskExecution execution = (LazyTaskExecution)history.configurations.remove(history.configurations.size() - 1);
                            if (execution.inputFilesSnapshotId != null) {
                                CacheBackedTaskHistoryRepository.this.snapshotRepository.remove(execution.inputFilesSnapshotId);
                            }
                            if (execution.outputFilesSnapshotId != null) {
                                CacheBackedTaskHistoryRepository.this.snapshotRepository.remove(execution.outputFilesSnapshotId);
                            }
                            if (execution.discoveredFilesSnapshotId == null) continue;
                            CacheBackedTaskHistoryRepository.this.snapshotRepository.remove(execution.discoveredFilesSnapshotId);
                        }
                        history.beforeSerialized();
                        CacheBackedTaskHistoryRepository.this.taskHistoryCache.put(task.getPath(), history);
                    }
                });
            }
        };
    }

    private TaskHistory loadHistory(final TaskInternal task) {
        return this.cacheAccess.useCache("Load task history", new Factory<TaskHistory>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public TaskHistory create() {
                ClassLoader original = CacheBackedTaskHistoryRepository.this.serializer.getClassLoader();
                CacheBackedTaskHistoryRepository.this.serializer.setClassLoader(task.getClass().getClassLoader());
                try {
                    TaskHistory history = (TaskHistory)CacheBackedTaskHistoryRepository.this.taskHistoryCache.get(task.getPath());
                    TaskHistory taskHistory = history == null ? new TaskHistory() : history;
                    return taskHistory;
                }
                finally {
                    CacheBackedTaskHistoryRepository.this.serializer.setClassLoader(original);
                }
            }
        });
    }

    private Set<String> outputFiles(TaskInternal task) {
        HashSet<String> outputFiles = new HashSet<String>();
        for (File file : task.getOutputs().getFiles()) {
            outputFiles.add(this.stringInterner.intern(file.getAbsolutePath()));
        }
        return outputFiles;
    }

    private LazyTaskExecution findPreviousExecution(TaskExecution currentExecution, TaskHistory history) {
        Set<String> outputFiles = currentExecution.getOutputFiles();
        LazyTaskExecution bestMatch = null;
        int bestMatchOverlap = 0;
        for (LazyTaskExecution configuration : history.configurations) {
            if (outputFiles.size() == 0 && configuration.getOutputFiles().size() == 0) {
                bestMatch = configuration;
                break;
            }
            HashSet<String> intersection = new HashSet<String>(outputFiles);
            intersection.retainAll(configuration.getOutputFiles());
            if (intersection.size() > bestMatchOverlap) {
                bestMatch = configuration;
                bestMatchOverlap = intersection.size();
            }
            if (bestMatchOverlap != outputFiles.size()) continue;
            break;
        }
        return bestMatch;
    }

    private static class LazyTaskExecution
    extends TaskExecution {
        private Long inputFilesSnapshotId;
        private Long outputFilesSnapshotId;
        private Long discoveredFilesSnapshotId;
        private transient FileSnapshotRepository snapshotRepository;
        private transient FileCollectionSnapshot inputFilesSnapshot;
        private transient FileCollectionSnapshot outputFilesSnapshot;
        private transient FileCollectionSnapshot discoveredFilesSnapshot;
        private transient TaskArtifactStateCacheAccess cacheAccess;

        private LazyTaskExecution() {
        }

        public FileCollectionSnapshot getInputFilesSnapshot() {
            if (this.inputFilesSnapshot == null) {
                this.inputFilesSnapshot = this.cacheAccess.useCache("fetch input files", new Factory<FileCollectionSnapshot>(){

                    public FileCollectionSnapshot create() {
                        return LazyTaskExecution.this.snapshotRepository.get(LazyTaskExecution.this.inputFilesSnapshotId);
                    }
                });
            }
            return this.inputFilesSnapshot;
        }

        public void setInputFilesSnapshot(FileCollectionSnapshot inputFilesSnapshot) {
            this.inputFilesSnapshot = inputFilesSnapshot;
            this.inputFilesSnapshotId = null;
        }

        public FileCollectionSnapshot getDiscoveredInputFilesSnapshot() {
            if (this.discoveredFilesSnapshot == null) {
                this.discoveredFilesSnapshot = this.cacheAccess.useCache("fetch discovered input files", new Factory<FileCollectionSnapshot>(){

                    public FileCollectionSnapshot create() {
                        return LazyTaskExecution.this.snapshotRepository.get(LazyTaskExecution.this.discoveredFilesSnapshotId);
                    }
                });
            }
            return this.discoveredFilesSnapshot;
        }

        public void setDiscoveredInputFilesSnapshot(FileCollectionSnapshot discoveredFilesSnapshot) {
            this.discoveredFilesSnapshot = discoveredFilesSnapshot;
            this.discoveredFilesSnapshotId = null;
        }

        public FileCollectionSnapshot getOutputFilesSnapshot() {
            if (this.outputFilesSnapshot == null) {
                this.outputFilesSnapshot = this.cacheAccess.useCache("fetch output files", new Factory<FileCollectionSnapshot>(){

                    public FileCollectionSnapshot create() {
                        return LazyTaskExecution.this.snapshotRepository.get(LazyTaskExecution.this.outputFilesSnapshotId);
                    }
                });
            }
            return this.outputFilesSnapshot;
        }

        public void setOutputFilesSnapshot(FileCollectionSnapshot outputFilesSnapshot) {
            this.outputFilesSnapshot = outputFilesSnapshot;
            this.outputFilesSnapshotId = null;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class TaskHistorySerializer
        implements Serializer<LazyTaskExecution> {
            private final InputPropertiesSerializer inputPropertiesSerializer;
            private final StringInterner stringInterner;

            public TaskHistorySerializer(ClassLoader classLoader, StringInterner stringInterner) {
                this.inputPropertiesSerializer = new InputPropertiesSerializer(classLoader);
                this.stringInterner = stringInterner;
            }

            public LazyTaskExecution read(Decoder decoder) throws Exception {
                LazyTaskExecution execution = new LazyTaskExecution();
                execution.inputFilesSnapshotId = decoder.readLong();
                execution.outputFilesSnapshotId = decoder.readLong();
                execution.discoveredFilesSnapshotId = decoder.readLong();
                execution.setTaskClass(decoder.readString());
                int outputFiles = decoder.readInt();
                HashSet<String> files = new HashSet<String>();
                for (int j = 0; j < outputFiles; ++j) {
                    files.add(this.stringInterner.intern(decoder.readString()));
                }
                execution.setOutputFiles(files);
                boolean inputProperties = decoder.readBoolean();
                if (inputProperties) {
                    Object map = this.inputPropertiesSerializer.read(decoder);
                    execution.setInputProperties((Map<String, Object>)map);
                } else {
                    execution.setInputProperties(new HashMap<String, Object>());
                }
                return execution;
            }

            public void write(Encoder encoder, LazyTaskExecution execution) throws Exception {
                encoder.writeLong(execution.inputFilesSnapshotId.longValue());
                encoder.writeLong(execution.outputFilesSnapshotId.longValue());
                encoder.writeLong(execution.discoveredFilesSnapshotId.longValue());
                encoder.writeString((CharSequence)execution.getTaskClass());
                encoder.writeInt(execution.getOutputFiles().size());
                for (String outputFile : execution.getOutputFiles()) {
                    encoder.writeString((CharSequence)outputFile);
                }
                if (execution.getInputProperties() == null || execution.getInputProperties().isEmpty()) {
                    encoder.writeBoolean(false);
                } else {
                    encoder.writeBoolean(true);
                    this.inputPropertiesSerializer.write(encoder, execution.getInputProperties());
                }
            }
        }
    }

    private static class TaskHistory {
        private static final int MAX_HISTORY_ENTRIES = 3;
        private final List<LazyTaskExecution> configurations = new ArrayList<LazyTaskExecution>();

        private TaskHistory() {
        }

        public String toString() {
            return super.toString() + "[" + this.configurations.size() + "]";
        }

        public void beforeSerialized() {
            for (LazyTaskExecution c : this.configurations) {
                c.cacheAccess = null;
                c.snapshotRepository = null;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TaskHistorySerializer
    implements Serializer<TaskHistory> {
        private ClassLoader classLoader;
        private final StringInterner stringInterner;

        public TaskHistorySerializer(StringInterner stringInterner) {
            this.stringInterner = stringInterner;
        }

        public TaskHistory read(Decoder decoder) throws Exception {
            int executions = decoder.readByte();
            TaskHistory history = new TaskHistory();
            LazyTaskExecution.TaskHistorySerializer executionSerializer = new LazyTaskExecution.TaskHistorySerializer(this.classLoader, this.stringInterner);
            for (int i = 0; i < executions; ++i) {
                LazyTaskExecution exec = executionSerializer.read(decoder);
                history.configurations.add(exec);
            }
            return history;
        }

        public void write(Encoder encoder, TaskHistory value) throws Exception {
            int size = value.configurations.size();
            encoder.writeByte((byte)size);
            LazyTaskExecution.TaskHistorySerializer executionSerializer = new LazyTaskExecution.TaskHistorySerializer(this.classLoader, this.stringInterner);
            for (LazyTaskExecution execution : value.configurations) {
                executionSerializer.write(encoder, execution);
            }
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public void setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
        }
    }
}

