/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.classpath;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.internal.GradleDistributionLocator;
import org.gradle.internal.classloader.ClasspathUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGradleDistributionLocator
implements GradleDistributionLocator {
    private final File distDir;
    private final List<File> libDirs = new ArrayList<File>();
    public static final FileFilter DIRECTORY_FILTER = new FileFilter(){

        public boolean accept(File pathname) {
            return pathname.isDirectory();
        }
    };

    public DefaultGradleDistributionLocator() {
        this(DefaultGradleDistributionLocator.class);
    }

    public DefaultGradleDistributionLocator(Class<?> clazz) {
        this(DefaultGradleDistributionLocator.findDistDir(clazz));
    }

    public DefaultGradleDistributionLocator(File distDir) {
        this.distDir = distDir;
        if (distDir != null) {
            this.libDirs.addAll(this.findLibDirs(distDir));
        }
    }

    private List<File> findLibDirs(File distDir) {
        ArrayList<File> libDirAndSubdirs = new ArrayList<File>();
        this.collectWithSubdirectories(new File(distDir, "lib"), libDirAndSubdirs);
        return libDirAndSubdirs;
    }

    private void collectWithSubdirectories(File root, Collection<File> collection) {
        collection.add(root);
        File[] subDirs = root.listFiles(DIRECTORY_FILTER);
        if (subDirs != null) {
            for (File subdirectory : subDirs) {
                this.collectWithSubdirectories(subdirectory, collection);
            }
        }
    }

    private static File findDistDir(Class<?> clazz) {
        File codeSource = ClasspathUtil.getClasspathForClass(clazz);
        if (codeSource.isFile()) {
            return DefaultGradleDistributionLocator.determineDistRootDir(codeSource);
        }
        return null;
    }

    private static File determineDistRootDir(File codeSource) {
        File parentDir = codeSource.getParentFile();
        if (parentDir.getName().equals("lib")) {
            File pluginsDir = new File(parentDir, "plugins");
            return parentDir.isDirectory() && pluginsDir.exists() && pluginsDir.isDirectory() ? parentDir.getParentFile() : null;
        }
        if (parentDir.getName().equals("plugins")) {
            File libDir = parentDir.getParentFile();
            return parentDir.isDirectory() && libDir.exists() && libDir.isDirectory() && libDir.getName().equals("lib") ? libDir.getParentFile() : null;
        }
        return null;
    }

    @Override
    public File getGradleHome() {
        return this.distDir;
    }

    @Override
    public List<File> getLibDirs() {
        return this.libDirs;
    }
}

