/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.rules;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.util.Map;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.internal.rules.NamedDomainObjectFactoryRegistry;
import org.gradle.api.internal.rules.RuleAwareNamedDomainObjectFactoryRegistry;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRuleAwareNamedDomainObjectFactoryRegistry<T>
implements RuleAwareNamedDomainObjectFactoryRegistry<T> {
    private final Map<Class<? extends T>, Optional<ModelRuleDescriptor>> creators = Maps.newHashMap();
    private final NamedDomainObjectFactoryRegistry<T> delegate;

    public DefaultRuleAwareNamedDomainObjectFactoryRegistry(NamedDomainObjectFactoryRegistry<T> delegate) {
        this.delegate = delegate;
    }

    @Override
    public <U extends T> void registerFactory(Class<U> type, NamedDomainObjectFactory<? extends U> factory) {
        this.registerFactory(type, factory, null);
    }

    @Override
    public <U extends T> void registerFactory(Class<U> type, NamedDomainObjectFactory<? extends U> factory, ModelRuleDescriptor descriptor) {
        this.checkCanRegister(type, descriptor);
        this.delegate.registerFactory(type, factory);
    }

    private void checkCanRegister(Class<? extends T> type, ModelRuleDescriptor descriptor) {
        Optional<ModelRuleDescriptor> creator = this.creators.get(type);
        if (creator != null) {
            StringBuilder builder = new StringBuilder("Cannot register a factory for type ").append(type.getSimpleName()).append(" because a factory for this type was already registered");
            if (creator.isPresent()) {
                builder.append(" by ");
                ((ModelRuleDescriptor)creator.get()).describeTo((Appendable)builder);
            }
            builder.append(".");
            throw new GradleException(builder.toString());
        }
        this.creators.put(type, (Optional<ModelRuleDescriptor>)Optional.fromNullable((Object)descriptor));
    }
}

