/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.io.LineProcessor;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.List;
import org.gradle.api.UncheckedIOException;
import org.gradle.configuration.ImportsReader;

public class DefaultImportsReader
implements ImportsReader {
    private static final String RESOURCE = "/default-imports.txt";
    private final String[] importPackages;

    public DefaultImportsReader() {
        try {
            URL url = this.getClass().getResource(RESOURCE);
            if (url == null) {
                throw new IllegalStateException("Could not load default imports resource: /default-imports.txt");
            }
            this.importPackages = (String[])Resources.asCharSource((URL)url, (Charset)Charsets.UTF_8).readLines((LineProcessor)new LineProcessor<String[]>(){
                private final List<String> packages = Lists.newLinkedList();

                public boolean processLine(String line) throws IOException {
                    this.packages.add(line.substring(7, line.length() - 2));
                    return true;
                }

                public String[] getResult() {
                    return this.packages.toArray(new String[this.packages.size()]);
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public String[] getImportPackages() {
        return this.importPackages;
    }
}

