/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.reporting;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.gradle.internal.html.SimpleHtmlWriter;
import org.gradle.reporting.ReportRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabsRenderer<T>
extends ReportRenderer<T, SimpleHtmlWriter> {
    private final List<TabDefinition> tabs = new ArrayList<TabDefinition>();

    public void add(String title, ReportRenderer<T, SimpleHtmlWriter> contentRenderer) {
        this.tabs.add(new TabDefinition(title, contentRenderer));
    }

    public void clear() {
        this.tabs.clear();
    }

    @Override
    public void render(T model, SimpleHtmlWriter htmlWriterWriter) throws IOException {
        String tabId;
        TabDefinition tab;
        int i;
        htmlWriterWriter.startElement("div").attribute("id", "tabs");
        htmlWriterWriter.startElement("ul").attribute("class", "tabLinks");
        for (i = 0; i < this.tabs.size(); ++i) {
            tab = this.tabs.get(i);
            tabId = String.format("tab%s", i);
            htmlWriterWriter.startElement("li");
            htmlWriterWriter.startElement("a").attribute("href", "#" + tabId).characters(tab.title).endElement();
            htmlWriterWriter.endElement();
        }
        htmlWriterWriter.endElement();
        for (i = 0; i < this.tabs.size(); ++i) {
            tab = this.tabs.get(i);
            tabId = String.format("tab%s", i);
            htmlWriterWriter.startElement("div").attribute("id", tabId).attribute("class", "tab");
            htmlWriterWriter.startElement("h2").characters(tab.title).endElement();
            tab.renderer.render(model, htmlWriterWriter);
            htmlWriterWriter.endElement();
        }
        htmlWriterWriter.endElement();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class TabDefinition {
        final String title;
        final ReportRenderer<T, SimpleHtmlWriter> renderer;

        private TabDefinition(String title, ReportRenderer<T, SimpleHtmlWriter> renderer) {
            this.title = title;
            this.renderer = renderer;
        }
    }
}

