/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import org.gradle.internal.io.TextStream;
import org.gradle.util.LineBufferingOutputStream;

public class LinePerThreadBufferingOutputStream
extends PrintStream {
    private final TextStream handler;
    private final ThreadLocal<PrintStream> stream = new ThreadLocal<PrintStream>(){

        @Override
        protected PrintStream initialValue() {
            return AccessController.doPrivileged(new PrivilegedAction<PrintStream>(){

                @Override
                public PrintStream run() {
                    return new PrintStream(new LineBufferingOutputStream(LinePerThreadBufferingOutputStream.this.handler));
                }
            });
        }
    };

    public LinePerThreadBufferingOutputStream(TextStream handler) {
        super(new ByteArrayOutputStream(), true);
        this.handler = handler;
    }

    private PrintStream getStream() {
        return this.stream.get();
    }

    public PrintStream append(CharSequence csq) {
        this.getStream().append(csq);
        return this;
    }

    public PrintStream append(char c) {
        this.getStream().append(c);
        return this;
    }

    public PrintStream append(CharSequence csq, int start, int end) {
        this.getStream().append(csq, start, end);
        return this;
    }

    public boolean checkError() {
        return this.getStream().checkError();
    }

    public void close() {
        this.getStream().close();
    }

    public void flush() {
        this.getStream().flush();
    }

    public PrintStream format(String format, Object ... args) {
        this.getStream().format(format, args);
        return this;
    }

    public PrintStream format(Locale l, String format, Object ... args) {
        this.getStream().format(l, format, args);
        return this;
    }

    public void print(boolean b) {
        this.getStream().print(b);
    }

    public void print(char c) {
        this.getStream().print(c);
    }

    public void print(double d) {
        this.getStream().print(d);
    }

    public void print(float f) {
        this.getStream().print(f);
    }

    public void print(int i) {
        this.getStream().print(i);
    }

    public void print(long l) {
        this.getStream().print(l);
    }

    public void print(Object obj) {
        this.getStream().print(obj);
    }

    public void print(char[] s) {
        this.getStream().print(s);
    }

    public void print(String s) {
        this.getStream().print(s);
    }

    public PrintStream printf(String format, Object ... args) {
        this.getStream().printf(format, args);
        return this;
    }

    public PrintStream printf(Locale l, String format, Object ... args) {
        this.getStream().printf(l, format, args);
        return this;
    }

    public void println() {
        this.getStream().println();
    }

    public void println(boolean x) {
        this.getStream().println(x);
    }

    public void println(char x) {
        this.getStream().println(x);
    }

    public void println(char[] x) {
        this.getStream().println(x);
    }

    public void println(double x) {
        this.getStream().println(x);
    }

    public void println(float x) {
        this.getStream().println(x);
    }

    public void println(int x) {
        this.getStream().println(x);
    }

    public void println(long x) {
        this.getStream().println(x);
    }

    public void println(Object x) {
        this.getStream().println(x);
    }

    public void println(String x) {
        this.getStream().println(x);
    }

    public void write(int b) {
        this.getStream().write(b);
    }

    public void write(byte[] buf, int off, int len) {
        this.getStream().write(buf, off, len);
    }

    public void write(byte[] b) throws IOException {
        this.getStream().write(b);
    }
}

