/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.cmdline.ProjectDescriptor;

public abstract class BuildRootDescriptor {
    public abstract String getRootId();

    public abstract File getRootFile();

    public abstract BuildTarget<?> getTarget();

    public FileFilter createFileFilter(@NotNull ProjectDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jps/builders/BuildRootDescriptor", "createFileFilter"));
        }
        return null;
    }

    @NotNull
    public FileFilter createFileFilter() {
        FileFilter fileFilter = FileUtilRt.ALL_FILES;
        if (fileFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/BuildRootDescriptor", "createFileFilter"));
        }
        return fileFilter;
    }

    @NotNull
    public Set<File> getExcludedRoots() {
        Set<File> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/BuildRootDescriptor", "getExcludedRoots"));
        }
        return set;
    }

    public boolean isGenerated() {
        return false;
    }

    public boolean canUseFileCache() {
        return false;
    }
}

