/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl.java;

import com.intellij.util.ExceptionUtil;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.java.CannotCreateJavaCompilerException;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.javac.JavacMain;

public class JavacCompilerTool
extends JavaCompilingTool {
    @Override
    @NotNull
    public String getId() {
        if ("Javac" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/java/JavacCompilerTool", "getId"));
        }
        return "Javac";
    }

    @Override
    @Nullable
    public String getAlternativeId() {
        return "compAPI";
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = "javac " + System.getProperty("java.version");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/java/JavacCompilerTool", "getDescription"));
        }
        return string;
    }

    @Override
    @NotNull
    public JavaCompiler createCompiler() throws CannotCreateJavaCompilerException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler != null) {
            JavaCompiler javaCompiler = compiler;
            if (javaCompiler == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/java/JavacCompilerTool", "createCompiler"));
            }
            return javaCompiler;
        }
        String message = "System Java Compiler was not found in classpath";
        try {
            Class.forName("com.sun.tools.javac.api.JavacTool", false, JavacMain.class.getClassLoader());
        }
        catch (Throwable ex) {
            message = message + ":\n" + ExceptionUtil.getThrowableText((Throwable)ex);
        }
        throw new CannotCreateJavaCompilerException(message);
    }

    @Override
    @NotNull
    public List<File> getAdditionalClasspath() {
        List<File> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/impl/java/JavacCompilerTool", "getAdditionalClasspath"));
        }
        return list;
    }

    @Override
    public List<String> getDefaultCompilerOptions() {
        return Collections.singletonList("-implicit:class");
    }
}

