/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts.instructions;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.artifacts.JarPathUtil;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactCompilerInstructionCreator;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactInstructionsBuilder;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactInstructionsBuilderImpl;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.DestinationInfo;
import org.jetbrains.jps.incremental.artifacts.instructions.FileBasedArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.FileCopyingHandler;
import org.jetbrains.jps.incremental.artifacts.instructions.JarBasedArtifactRootDescriptor;
import org.jetbrains.jps.incremental.artifacts.instructions.SourceFileFilter;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;

public abstract class ArtifactCompilerInstructionCreatorBase
implements ArtifactCompilerInstructionCreator {
    protected final ArtifactInstructionsBuilderImpl myInstructionsBuilder;

    public ArtifactCompilerInstructionCreatorBase(ArtifactInstructionsBuilderImpl instructionsBuilder) {
        this.myInstructionsBuilder = instructionsBuilder;
    }

    @Override
    public void addDirectoryCopyInstructions(@NotNull File directoryUrl) {
        if (directoryUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryUrl", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactCompilerInstructionCreatorBase", "addDirectoryCopyInstructions"));
        }
        this.addDirectoryCopyInstructions(directoryUrl, null);
    }

    @Override
    public void addDirectoryCopyInstructions(@NotNull File directory, @Nullable SourceFileFilter filter) {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactCompilerInstructionCreatorBase", "addDirectoryCopyInstructions"));
        }
        this.addDirectoryCopyInstructions(directory, filter, FileCopyingHandler.DEFAULT);
    }

    @Override
    public void addDirectoryCopyInstructions(@NotNull File directory, @Nullable SourceFileFilter filter, @NotNull FileCopyingHandler copyingHandler) {
        FileBasedArtifactRootDescriptor descriptor;
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directory", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactCompilerInstructionCreatorBase", "addDirectoryCopyInstructions"));
        }
        if (copyingHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyingHandler", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactCompilerInstructionCreatorBase", "addDirectoryCopyInstructions"));
        }
        boolean copyExcluded = this.myInstructionsBuilder.getRootsIndex().isExcluded(directory);
        SourceFileFilterImpl fileFilter = new SourceFileFilterImpl(filter, this.myInstructionsBuilder.getRootsIndex(), this.myInstructionsBuilder.getIgnoredFileIndex(), copyExcluded);
        DestinationInfo destination = this.createDirectoryDestination();
        if (destination != null && this.myInstructionsBuilder.addDestination(descriptor = this.myInstructionsBuilder.createFileBasedRoot(directory, fileFilter, destination, copyingHandler))) {
            this.onAdded(descriptor);
        }
    }

    @Override
    public void addExtractDirectoryInstruction(@NotNull File jarFile, @NotNull String pathInJar) {
        if (jarFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarFile", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactCompilerInstructionCreatorBase", "addExtractDirectoryInstruction"));
        }
        if (pathInJar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathInJar", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactCompilerInstructionCreatorBase", "addExtractDirectoryInstruction"));
        }
        this.addExtractDirectoryInstruction(jarFile, pathInJar, (Condition<String>)Conditions.alwaysTrue());
    }

    @Override
    public void addExtractDirectoryInstruction(@NotNull File jarFile, @NotNull String pathInJar, @NotNull Condition<String> pathInJarFilter) {
        JarBasedArtifactRootDescriptor descriptor;
        if (jarFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jarFile", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactCompilerInstructionCreatorBase", "addExtractDirectoryInstruction"));
        }
        if (pathInJar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathInJar", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactCompilerInstructionCreatorBase", "addExtractDirectoryInstruction"));
        }
        if (pathInJarFilter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pathInJarFilter", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactCompilerInstructionCreatorBase", "addExtractDirectoryInstruction"));
        }
        boolean includeExcluded = true;
        SourceFileFilterImpl filter = new SourceFileFilterImpl(null, this.myInstructionsBuilder.getRootsIndex(), this.myInstructionsBuilder.getIgnoredFileIndex(), includeExcluded);
        DestinationInfo destination = this.createDirectoryDestination();
        if (destination != null && this.myInstructionsBuilder.addDestination(descriptor = this.myInstructionsBuilder.createJarBasedRoot(jarFile, pathInJar, filter, destination, pathInJarFilter))) {
            this.onAdded(descriptor);
        }
    }

    @Override
    public abstract ArtifactCompilerInstructionCreatorBase subFolder(@NotNull String var1);

    @Override
    public ArtifactCompilerInstructionCreator subFolderByRelativePath(@NotNull String relativeDirectoryPath) {
        if (relativeDirectoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativeDirectoryPath", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactCompilerInstructionCreatorBase", "subFolderByRelativePath"));
        }
        List folders = StringUtil.split((String)relativeDirectoryPath, (String)"/");
        ArtifactCompilerInstructionCreator current = this;
        for (String folder : folders) {
            current = current.subFolder(folder);
        }
        return current;
    }

    @Override
    public void addFileCopyInstruction(@NotNull File file, @NotNull String outputFileName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactCompilerInstructionCreatorBase", "addFileCopyInstruction"));
        }
        if (outputFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFileName", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactCompilerInstructionCreatorBase", "addFileCopyInstruction"));
        }
        this.addFileCopyInstruction(file, outputFileName, FileCopyingHandler.DEFAULT);
    }

    @Override
    public void addFileCopyInstruction(@NotNull File file, @NotNull String outputFileName, @NotNull FileCopyingHandler copyingHandler) {
        FileBasedArtifactRootDescriptor root;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactCompilerInstructionCreatorBase", "addFileCopyInstruction"));
        }
        if (outputFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFileName", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactCompilerInstructionCreatorBase", "addFileCopyInstruction"));
        }
        if (copyingHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copyingHandler", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactCompilerInstructionCreatorBase", "addFileCopyInstruction"));
        }
        DestinationInfo destination = this.createFileDestination(outputFileName);
        if (destination != null && this.myInstructionsBuilder.addDestination(root = this.myInstructionsBuilder.createFileBasedRoot(file, SourceFileFilter.ALL, destination, copyingHandler))) {
            this.onAdded(root);
        }
    }

    @Override
    public ArtifactInstructionsBuilder getInstructionsBuilder() {
        return this.myInstructionsBuilder;
    }

    @Nullable
    protected abstract DestinationInfo createDirectoryDestination();

    protected abstract DestinationInfo createFileDestination(@NotNull String var1);

    protected abstract void onAdded(ArtifactRootDescriptor var1);

    private static class SourceFileFilterImpl
    extends SourceFileFilter {
        private final SourceFileFilter myBaseFilter;
        private final ModuleExcludeIndex myRootsIndex;
        private final IgnoredFileIndex myIgnoredFileIndex;
        private final boolean myIncludeExcluded;

        private SourceFileFilterImpl(@Nullable SourceFileFilter baseFilter, @NotNull ModuleExcludeIndex rootsIndex, IgnoredFileIndex patterns, boolean includeExcluded) {
            if (rootsIndex == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootsIndex", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactCompilerInstructionCreatorBase$SourceFileFilterImpl", "<init>"));
            }
            this.myBaseFilter = baseFilter;
            this.myRootsIndex = rootsIndex;
            this.myIgnoredFileIndex = patterns;
            this.myIncludeExcluded = includeExcluded;
        }

        @Override
        public boolean accept(@NotNull String fullFilePath) {
            File file;
            if (fullFilePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullFilePath", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactCompilerInstructionCreatorBase$SourceFileFilterImpl", "accept"));
            }
            if (this.myBaseFilter != null && !this.myBaseFilter.accept(fullFilePath)) {
                return false;
            }
            if (this.myIgnoredFileIndex.isIgnored(PathUtilRt.getFileName((String)fullFilePath))) {
                return false;
            }
            return this.myIncludeExcluded || !this.myRootsIndex.isExcluded(file = JarPathUtil.getLocalFile(fullFilePath));
        }

        @Override
        public boolean shouldBeCopied(@NotNull String fullFilePath, ProjectDescriptor projectDescriptor) throws IOException {
            if (fullFilePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullFilePath", "org/jetbrains/jps/incremental/artifacts/instructions/ArtifactCompilerInstructionCreatorBase$SourceFileFilterImpl", "shouldBeCopied"));
            }
            return this.myBaseFilter == null || this.myBaseFilter.shouldBeCopied(fullFilePath, projectDescriptor);
        }
    }
}

