/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import javax.swing.Icon;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.lang.xpath.xslt.impl.XsltChecker;
import org.intellij.plugins.xsltDebugger.impl.XsltDebuggerEditorsProvider;
import org.jetbrains.annotations.NotNull;

public class XsltBreakpointType
extends XLineBreakpointType<XBreakpointProperties> {
    private final XsltDebuggerEditorsProvider myMyEditorsProvider1 = new XsltDebuggerEditorsProvider(XsltChecker.LanguageLevel.V1);
    private final XsltDebuggerEditorsProvider myMyEditorsProvider2 = new XsltDebuggerEditorsProvider(XsltChecker.LanguageLevel.V2);

    public XsltBreakpointType() {
        super("xslt", "XSLT Breakpoints");
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/xsltDebugger/XsltBreakpointType", "canPutAt"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/xsltDebugger/XsltBreakpointType", "canPutAt"));
        }
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return false;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        if (psiFile == null) {
            return false;
        }
        FileType fileType = psiFile.getFileType();
        return fileType == StdFileTypes.XML && XsltSupport.isXsltFile((PsiFile)psiFile);
    }

    public XDebuggerEditorsProvider getEditorsProvider(@NotNull XLineBreakpoint<XBreakpointProperties> breakpoint, @NotNull Project project) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/intellij/plugins/xsltDebugger/XsltBreakpointType", "getEditorsProvider"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/intellij/plugins/xsltDebugger/XsltBreakpointType", "getEditorsProvider"));
        }
        XSourcePosition position = breakpoint.getSourcePosition();
        if (position == null) {
            return null;
        }
        PsiFile file = PsiManager.getInstance((Project)project).findFile(position.getFile());
        if (file == null) {
            return null;
        }
        XsltChecker.LanguageLevel level = XsltSupport.getXsltLanguageLevel((PsiFile)file);
        if (level == XsltChecker.LanguageLevel.V1) {
            return this.myMyEditorsProvider1;
        }
        if (level == XsltChecker.LanguageLevel.V2) {
            return this.myMyEditorsProvider2;
        }
        return null;
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon = XsltSupport.createXsltIcon((Icon)AllIcons.Debugger.Db_set_breakpoint);
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xsltDebugger/XsltBreakpointType", "getEnabledIcon"));
        }
        return icon;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon = XsltSupport.createXsltIcon((Icon)AllIcons.Debugger.Db_disabled_breakpoint);
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xsltDebugger/XsltBreakpointType", "getDisabledIcon"));
        }
        return icon;
    }

    public XBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file, int line) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/xsltDebugger/XsltBreakpointType", "createBreakpointProperties"));
        }
        return null;
    }
}

