/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger.impl;

import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.XSourcePositionWrapper;
import java.net.URI;
import java.net.URL;
import org.intellij.plugins.xsltDebugger.rt.engine.Debugger;
import org.jetbrains.annotations.Nullable;

public class XsltSourcePosition
extends XSourcePositionWrapper {
    private final Debugger.Locatable myLocation;

    XsltSourcePosition(Debugger.Locatable location, XSourcePosition position) {
        super(position);
        this.myLocation = location;
    }

    @Nullable
    public static XSourcePosition create(Debugger.Locatable location) {
        VirtualFile file;
        try {
            file = VfsUtil.findFileByURL((URL)new URI(location.getURI()).toURL());
        }
        catch (Exception e) {
            return null;
        }
        int line = location.getLineNumber() - 1;
        XSourcePosition position = XDebuggerUtil.getInstance().createPosition(file, line);
        return line >= 0 && position != null ? new XsltSourcePosition(location, position) : null;
    }

    public Debugger.Locatable getLocation() {
        return this.myLocation;
    }
}

