/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.byteCodeViewer;

import com.intellij.execution.filters.LineNumbersMapping;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.DocumentUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;

public class ByteCodeViewerComponent
extends JPanel
implements Disposable {
    private final Editor myEditor;

    public ByteCodeViewerComponent(Project project, AnAction[] additionalActions) {
        super(new BorderLayout());
        EditorFactory factory = EditorFactory.getInstance();
        Document doc = ((EditorFactoryImpl)factory).createDocument((CharSequence)"", true, false);
        doc.setReadOnly(true);
        this.myEditor = factory.createEditor(doc, project);
        EditorHighlighterFactory editorHighlighterFactory = EditorHighlighterFactory.getInstance();
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)StdFileTypes.JAVA, (Project)project, null);
        ((EditorEx)this.myEditor).setHighlighter(editorHighlighterFactory.createEditorHighlighter(syntaxHighlighter, EditorColorsManager.getInstance().getGlobalScheme()));
        ((EditorEx)this.myEditor).setCaretVisible(true);
        EditorSettings settings = this.myEditor.getSettings();
        settings.setLineMarkerAreaShown(false);
        settings.setIndentGuidesShown(false);
        settings.setLineNumbersShown(false);
        settings.setFoldingOutlineShown(false);
        this.myEditor.setBorder(null);
        this.add((Component)this.myEditor.getComponent(), "Center");
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup actions = new DefaultActionGroup();
        if (additionalActions != null) {
            for (AnAction action : additionalActions) {
                actions.add(action);
            }
        }
        this.add((Component)actionManager.createActionToolbar("JavadocToolbar", (ActionGroup)actions, true).getComponent(), "North");
    }

    public void setText(String bytecode) {
        this.setText(bytecode, 0);
    }

    public void setText(String bytecode, PsiElement element) {
        int offset = 0;
        PsiFile psiFile = element.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)element.getProject()).getDocument(psiFile);
        if (document != null) {
            LineNumbersMapping mapping;
            int lineNumber = document.getLineNumber(element.getTextOffset());
            VirtualFile file = psiFile.getVirtualFile();
            if (file != null && (mapping = (LineNumbersMapping)file.getUserData(LineNumbersMapping.LINE_NUMBERS_MAPPING_KEY)) != null) {
                int mappedLine = mapping.sourceToBytecode(lineNumber);
                while (mappedLine == -1 && lineNumber < document.getLineCount()) {
                    mappedLine = mapping.sourceToBytecode(++lineNumber);
                }
                if (mappedLine > 0) {
                    lineNumber = mappedLine;
                }
            }
            offset = bytecode.indexOf("LINENUMBER " + lineNumber);
            while (offset == -1 && lineNumber < document.getLineCount()) {
                offset = bytecode.indexOf("LINENUMBER " + lineNumber++);
            }
        }
        this.setText(bytecode, Math.max(0, offset));
    }

    public void setText(final String bytecode, final int offset) {
        DocumentUtil.writeInRunUndoTransparentAction((Runnable)new Runnable(){

            @Override
            public void run() {
                Document fragmentDoc = ByteCodeViewerComponent.this.myEditor.getDocument();
                fragmentDoc.setReadOnly(false);
                fragmentDoc.replaceString(0, fragmentDoc.getTextLength(), (CharSequence)bytecode);
                fragmentDoc.setReadOnly(true);
                ByteCodeViewerComponent.this.myEditor.getCaretModel().moveToOffset(offset);
                ByteCodeViewerComponent.this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            }
        });
    }

    public String getText() {
        return this.myEditor.getDocument().getText();
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor(this.myEditor);
    }
}

