/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.tree.filter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.filter.DependencyNodeFilter;

public class AndDependencyNodeFilter
implements DependencyNodeFilter {
    private final List filters;

    public AndDependencyNodeFilter(DependencyNodeFilter filter1, DependencyNodeFilter filter2) {
        this(Arrays.asList(filter1, filter2));
    }

    public AndDependencyNodeFilter(List filters) {
        this.filters = Collections.unmodifiableList(filters);
    }

    public boolean accept(DependencyNode node) {
        boolean accept = true;
        Iterator iterator = this.filters.iterator();
        while (accept && iterator.hasNext()) {
            DependencyNodeFilter filter = (DependencyNodeFilter)iterator.next();
            accept = filter.accept(node);
        }
        return accept;
    }

    public List getDependencyNodeFilters() {
        return this.filters;
    }
}

