/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template.utility;

import freemarker.template.utility.UnsupportedNumberClassException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberUtil {
    private NumberUtil() {
    }

    public static boolean isInfinite(Number num) {
        if (num instanceof Double) {
            return ((Double)num).isInfinite();
        }
        if (num instanceof Float) {
            return ((Float)num).isInfinite();
        }
        if (NumberUtil.isNonFPNumberOfSupportedClass(num)) {
            return false;
        }
        throw new UnsupportedNumberClassException(num.getClass());
    }

    public static boolean isNaN(Number num) {
        if (num instanceof Double) {
            return ((Double)num).isNaN();
        }
        if (num instanceof Float) {
            return ((Float)num).isNaN();
        }
        if (NumberUtil.isNonFPNumberOfSupportedClass(num)) {
            return false;
        }
        throw new UnsupportedNumberClassException(num.getClass());
    }

    public static int getSignum(Number num) throws ArithmeticException {
        if (num instanceof Integer) {
            int n = (Integer)num;
            return n > 0 ? 1 : (n == 0 ? 0 : -1);
        }
        if (num instanceof BigDecimal) {
            BigDecimal n = (BigDecimal)num;
            return n.signum();
        }
        if (num instanceof Double) {
            double n = (Double)num;
            if (n > 0.0) {
                return 1;
            }
            if (n == 0.0) {
                return 0;
            }
            if (n < 0.0) {
                return -1;
            }
            throw new ArithmeticException("The signum of " + n + " is not defined.");
        }
        if (num instanceof Float) {
            float n = ((Float)num).floatValue();
            if (n > 0.0f) {
                return 1;
            }
            if (n == 0.0f) {
                return 0;
            }
            if (n < 0.0f) {
                return -1;
            }
            throw new ArithmeticException("The signum of " + n + " is not defined.");
        }
        if (num instanceof Long) {
            long n = (Long)num;
            return n > 0L ? 1 : (n == 0L ? 0 : -1);
        }
        if (num instanceof Short) {
            short n = (Short)num;
            return n > 0 ? 1 : (n == 0 ? 0 : -1);
        }
        if (num instanceof Byte) {
            byte n = (Byte)num;
            return n > 0 ? 1 : (n == 0 ? 0 : -1);
        }
        if (num instanceof BigInteger) {
            BigInteger n = (BigInteger)num;
            return n.signum();
        }
        throw new UnsupportedNumberClassException(num.getClass());
    }

    private static boolean isNonFPNumberOfSupportedClass(Number num) {
        return num instanceof Integer || num instanceof BigDecimal || num instanceof Long || num instanceof Short || num instanceof Byte || num instanceof BigInteger;
    }
}

