/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.gradle.tooling.model.Model;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModelsHolder<K extends Model, V>
implements Serializable {
    @NotNull
    private final K myRootModel;
    @NotNull
    private final Map<String, Object> myModelsById;

    public ModelsHolder(@NotNull K rootModel) {
        if (rootModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModel", "org/jetbrains/plugins/gradle/model/ModelsHolder", "<init>"));
        }
        this.myModelsById = new HashMap<String, Object>();
        this.myRootModel = rootModel;
    }

    @NotNull
    public K getRootModel() {
        K k = this.myRootModel;
        if (k == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/ModelsHolder", "getRootModel"));
        }
        return k;
    }

    @Nullable
    public <T> T getExtraProject(Class<T> modelClazz) {
        return this.getExtraProject(null, modelClazz);
    }

    @Nullable
    public <T> T getExtraProject(@Nullable V model, Class<T> modelClazz) {
        Object project = this.myModelsById.get(this.extractMapKey(modelClazz, model));
        if (modelClazz.isInstance(project)) {
            return (T)project;
        }
        return null;
    }

    @NotNull
    public Collection<String> findModulesWithModel(@NotNull Class modelClazz) {
        if (modelClazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelClazz", "org/jetbrains/plugins/gradle/model/ModelsHolder", "findModulesWithModel"));
        }
        ArrayList<String> modules = new ArrayList<String>();
        for (Map.Entry<String, Object> set : this.myModelsById.entrySet()) {
            if (!modelClazz.isInstance(set.getValue())) continue;
            modules.add(ModelsHolder.extractModulePath(modelClazz, set.getKey()));
        }
        ArrayList<String> arrayList = modules;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/ModelsHolder", "findModulesWithModel"));
        }
        return arrayList;
    }

    public boolean hasModulesWithModel(@NotNull Class modelClazz) {
        if (modelClazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelClazz", "org/jetbrains/plugins/gradle/model/ModelsHolder", "hasModulesWithModel"));
        }
        for (Map.Entry<String, Object> set : this.myModelsById.entrySet()) {
            if (!modelClazz.isInstance(set.getValue())) continue;
            return true;
        }
        return false;
    }

    public void addExtraProject(@NotNull Object project, @NotNull Class modelClazz) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/model/ModelsHolder", "addExtraProject"));
        }
        if (modelClazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelClazz", "org/jetbrains/plugins/gradle/model/ModelsHolder", "addExtraProject"));
        }
        this.myModelsById.put(this.extractMapKey(modelClazz, null), project);
    }

    public void addExtraProject(@NotNull Object project, @NotNull Class modelClazz, @Nullable V subPropject) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/gradle/model/ModelsHolder", "addExtraProject"));
        }
        if (modelClazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelClazz", "org/jetbrains/plugins/gradle/model/ModelsHolder", "addExtraProject"));
        }
        this.myModelsById.put(this.extractMapKey(modelClazz, subPropject), project);
    }

    @NotNull
    protected abstract String extractMapKey(Class var1, @Nullable V var2);

    @NotNull
    private static String extractModulePath(Class modelClazz, String key) {
        String string = key.replaceFirst(modelClazz.getName() + '@', "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/gradle/model/ModelsHolder", "extractModulePath"));
        }
        return string;
    }

    public String toString() {
        return "Models{rootModel=" + this.myRootModel + ", myModelsById=" + this.myModelsById + '}';
    }
}

