/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.index.DocFieldConsumer;
import org.apache.lucene.index.DocFieldConsumerPerThread;
import org.apache.lucene.index.DocFieldProcessorPerThread;
import org.apache.lucene.index.DocInverterPerField;
import org.apache.lucene.index.DocInverterPerThread;
import org.apache.lucene.index.DocumentsWriter;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.InvertedDocConsumer;
import org.apache.lucene.index.InvertedDocConsumerPerField;
import org.apache.lucene.index.InvertedDocEndConsumer;
import org.apache.lucene.index.InvertedDocEndConsumerPerField;

final class DocInverter
extends DocFieldConsumer {
    final InvertedDocConsumer consumer;
    final InvertedDocEndConsumer endConsumer;

    public DocInverter(InvertedDocConsumer consumer, InvertedDocEndConsumer endConsumer) {
        this.consumer = consumer;
        this.endConsumer = endConsumer;
    }

    void setFieldInfos(FieldInfos fieldInfos) {
        super.setFieldInfos(fieldInfos);
        this.consumer.setFieldInfos(fieldInfos);
        this.endConsumer.setFieldInfos(fieldInfos);
    }

    void flush(Map threadsAndFields, DocumentsWriter.FlushState state) throws IOException {
        HashMap childThreadsAndFields = new HashMap();
        HashMap endChildThreadsAndFields = new HashMap();
        Iterator it = threadsAndFields.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            DocInverterPerThread perThread = (DocInverterPerThread)entry.getKey();
            Collection fields = (Collection)entry.getValue();
            Iterator fieldsIt = fields.iterator();
            HashSet<InvertedDocConsumerPerField> childFields = new HashSet<InvertedDocConsumerPerField>();
            HashSet<InvertedDocEndConsumerPerField> endChildFields = new HashSet<InvertedDocEndConsumerPerField>();
            while (fieldsIt.hasNext()) {
                DocInverterPerField perField = (DocInverterPerField)fieldsIt.next();
                childFields.add(perField.consumer);
                endChildFields.add(perField.endConsumer);
            }
            childThreadsAndFields.put(perThread.consumer, childFields);
            endChildThreadsAndFields.put(perThread.endConsumer, endChildFields);
        }
        this.consumer.flush(childThreadsAndFields, state);
        this.endConsumer.flush(endChildThreadsAndFields, state);
    }

    public void closeDocStore(DocumentsWriter.FlushState state) throws IOException {
        this.consumer.closeDocStore(state);
        this.endConsumer.closeDocStore(state);
    }

    void abort() {
        this.consumer.abort();
        this.endConsumer.abort();
    }

    public boolean freeRAM() {
        return this.consumer.freeRAM();
    }

    public DocFieldConsumerPerThread addThread(DocFieldProcessorPerThread docFieldProcessorPerThread) {
        return new DocInverterPerThread(docFieldProcessorPerThread, this);
    }

    static final class FieldInvertState {
        int position;
        int length;
        int offset;
        float boost;

        FieldInvertState() {
        }

        void reset(float docBoost) {
            this.position = 0;
            this.length = 0;
            this.offset = 0;
            this.boost = docBoost;
        }
    }
}

