/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.core;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Nullable;
import org.gradle.internal.Cast;
import org.gradle.model.internal.core.AbstractModelAction;
import org.gradle.model.internal.core.InstanceFactory;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.ModelViews;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodeInitializer;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.core.UnmanagedModelProjection;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.AbstractManagedModelInitializer;
import org.gradle.model.internal.manage.instance.ManagedProxyFactory;
import org.gradle.model.internal.manage.projection.ManagedModelProjection;
import org.gradle.model.internal.manage.schema.ModelManagedImplStructSchema;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.ModelStructSchema;
import org.gradle.model.internal.type.ModelType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FactoryBasedManagedNodeInitializer<T, S extends T>
extends AbstractManagedModelInitializer<S>
implements NodeInitializer {
    private final InstanceFactory<T> instanceFactory;
    private final Action<? super T> configureAction;

    public FactoryBasedManagedNodeInitializer(InstanceFactory<T> instanceFactory, ModelManagedImplStructSchema<S> modelSchema, ModelSchemaStore schemaStore, ManagedProxyFactory proxyFactory, Action<? super T> configureAction) {
        super(modelSchema, schemaStore, proxyFactory);
        this.instanceFactory = instanceFactory;
        this.configureAction = configureAction;
    }

    @Override
    public List<? extends ModelReference<?>> getInputs() {
        return Collections.singletonList(ModelReference.of(NodeInitializerRegistry.class));
    }

    @Override
    public void execute(MutableModelNode modelNode, List<ModelView<?>> inputs) {
        ModelType type = this.schema.getType();
        InstanceFactory.ManagedSubtypeImplementationInfo<T> implementationInfo = this.instanceFactory.getManagedSubtypeImplementationInfo(type);
        T instance = this.instanceFactory.create(implementationInfo.getPublicType(), modelNode, modelNode.getPath().getName());
        this.configureAction.execute(instance);
        ModelType delegateType = (ModelType)Cast.uncheckedCast(implementationInfo.getDelegateType());
        modelNode.setPrivateData(delegateType, instance);
        NodeInitializerRegistry nodeInitializerRegistry = ModelViews.assertType(inputs.get(0), NodeInitializerRegistry.class).getInstance();
        ModelStructSchema delegateSchema = (ModelStructSchema)Cast.uncheckedCast(this.schemaStore.getSchema(delegateType));
        this.addPropertyLinks(modelNode, nodeInitializerRegistry, this.getProperties(delegateSchema));
    }

    private Collection<ModelProperty<?>> getProperties(ModelStructSchema<T> delegateSchema) {
        ImmutableSet.Builder properties = ImmutableSet.builder();
        this.addNonDelegatedManagedProperties(this.schema, delegateSchema, properties);
        for (ModelType<?> internalView : this.instanceFactory.getInternalViews(this.schema.getType())) {
            ModelSchema<?> internalViewSchema = this.schemaStore.getSchema(internalView);
            if (!(internalViewSchema instanceof ModelManagedImplStructSchema)) continue;
            this.addNonDelegatedManagedProperties((ModelManagedImplStructSchema)internalViewSchema, delegateSchema, properties);
        }
        return properties.build();
    }

    private void addNonDelegatedManagedProperties(ModelManagedImplStructSchema<?> schema, ModelStructSchema<T> delegateSchema, ImmutableSet.Builder<ModelProperty<?>> properties) {
        for (ModelProperty<?> property : schema.getProperties()) {
            if (property.getStateManagementType() != ModelProperty.StateManagementType.MANAGED || delegateSchema.hasProperty(property.getName())) continue;
            properties.add(property);
        }
    }

    @Override
    public List<? extends ModelProjection> getProjections() {
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public ModelAction getProjector(ModelPath path, ModelRuleDescriptor descriptor) {
        return new AbstractModelAction<Object>(ModelReference.of(path), descriptor, new ModelReference[]{ModelReference.of("schemaStore", ModelSchemaStore.class), ModelReference.of(ManagedProxyFactory.class)}){

            @Override
            public void execute(MutableModelNode modelNode, List<ModelView<?>> inputs) {
                ModelSchemaStore schemaStore = ModelViews.getInstance(inputs.get(0), ModelSchemaStore.class);
                ManagedProxyFactory proxyFactory = ModelViews.getInstance(inputs.get(1), ManagedProxyFactory.class);
                ModelType managedType = FactoryBasedManagedNodeInitializer.this.schema.getType();
                InstanceFactory.ManagedSubtypeImplementationInfo implementationInfo = FactoryBasedManagedNodeInitializer.this.instanceFactory.getManagedSubtypeImplementationInfo(managedType);
                if (implementationInfo == null) {
                    throw new IllegalStateException(String.format("No default implementation registered for managed type '%s'", managedType));
                }
                ModelType delegateType = implementationInfo.getDelegateType();
                ModelSchema delegateSchema = schemaStore.getSchema(delegateType);
                if (!(delegateSchema instanceof ModelStructSchema)) {
                    throw new IllegalStateException(String.format("Default implementation '%s' registered for managed type '%s' must be a struct", delegateType, managedType));
                }
                ModelStructSchema delegateStructSchema = (ModelStructSchema)Cast.uncheckedCast(delegateSchema);
                this.addProjection(modelNode, managedType, delegateStructSchema, schemaStore, proxyFactory);
                for (ModelType<?> internalView : FactoryBasedManagedNodeInitializer.this.instanceFactory.getInternalViews(managedType)) {
                    this.addProjection(modelNode, internalView, delegateStructSchema, schemaStore, proxyFactory);
                }
            }

            private <D> void addProjection(MutableModelNode modelNode, ModelType<?> type, ModelStructSchema<? extends D> delegateSchema, ModelSchemaStore schemaStore, ManagedProxyFactory proxyFactory) {
                ManagedModelProjection<? extends D> projection;
                ModelSchema<?> schema = schemaStore.getSchema(type);
                if (!(schema instanceof ModelStructSchema)) {
                    throw new IllegalStateException("View type must be a struct: " + type);
                }
                if (schema instanceof ModelManagedImplStructSchema) {
                    ModelManagedImplStructSchema structSchema = (ModelManagedImplStructSchema)Cast.uncheckedCast(schema);
                    projection = new ManagedModelProjection<D>(structSchema, delegateSchema, schemaStore, proxyFactory);
                } else {
                    projection = UnmanagedModelProjection.of(type);
                }
                modelNode.addProjection(projection);
            }
        };
    }
}

