/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.inspect;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import net.jcip.annotations.ThreadSafe;
import org.gradle.internal.UncheckedException;
import org.gradle.model.internal.inspect.ModelRuleInvoker;
import org.gradle.model.internal.method.WeaklyTypeReferencingMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
class DefaultModelRuleInvoker<I, R>
implements ModelRuleInvoker<R> {
    private final WeaklyTypeReferencingMethod<I, R> method;

    DefaultModelRuleInvoker(WeaklyTypeReferencingMethod<I, R> method) {
        this.method = method;
    }

    @Override
    public R invoke(Object ... args) {
        Object instance = Modifier.isStatic(this.method.getModifiers()) ? null : (Object)this.toInstance();
        return this.method.invoke(instance, args);
    }

    private I toInstance() {
        try {
            Class<I> concreteClass = this.method.getTarget().getConcreteClass();
            Constructor<I> declaredConstructor = concreteClass.getDeclaredConstructor(new Class[0]);
            declaredConstructor.setAccessible(true);
            return declaredConstructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e.getTargetException());
        }
    }
}

