/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.manage.schema.extract;

import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.internal.reflect.MethodSignatureEquivalence;
import org.gradle.model.internal.asm.AsmClassGeneratorUtils;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.manage.instance.ManagedInstance;
import org.gradle.model.internal.manage.instance.ModelElementState;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelStructSchema;
import org.gradle.model.internal.manage.schema.extract.AbstractProxyClassGenerator;
import org.gradle.model.internal.manage.schema.extract.ModelSchemaUtils;
import org.gradle.model.internal.method.WeaklyTypeReferencingMethod;
import org.gradle.model.internal.type.ModelType;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedProxyClassGenerator
extends AbstractProxyClassGenerator {
    private static final String STATE_FIELD_NAME = "$state";
    private static final String MANAGED_TYPE_FIELD_NAME = "$managedType";
    private static final String DELEGATE_FIELD_NAME = "$delegate";
    private static final String CAN_CALL_SETTERS_FIELD_NAME = "$canCallSetters";
    private static final String STATE_SET_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class), Type.getType(Object.class)});
    private static final String MANAGED_INSTANCE_TYPE = Type.getInternalName(ManagedInstance.class);
    private static final Type MODEL_ELEMENT_STATE_TYPE = Type.getType(ModelElementState.class);
    private static final String NO_DELEGATE_CONSTRUCTOR_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{MODEL_ELEMENT_STATE_TYPE});
    private static final String TO_STRING_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[0]);
    private static final String MUTABLE_MODEL_NODE_TYPE = Type.getInternalName(MutableModelNode.class);
    private static final String GET_BACKING_NODE_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(MutableModelNode.class), (Type[])new Type[0]);
    private static final Type MODELTYPE_TYPE = Type.getType(ModelType.class);
    private static final String MODELTYPE_INTERNAL_NAME = MODELTYPE_TYPE.getInternalName();
    private static final String MODELTYPE_OF_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)MODELTYPE_TYPE, (Type[])new Type[]{Type.getType(Class.class)});
    private static final String GET_MANAGED_TYPE_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)MODELTYPE_TYPE, (Type[])new Type[0]);
    private static final String GET_PROPERTY_MISSING_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(String.class)});
    private static final String MISSING_PROPERTY_EXCEPTION_TYPE = Type.getInternalName(MissingPropertyException.class);
    private static final String CLASS_TYPE = Type.getInternalName(Class.class);
    private static final String FOR_NAME_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(Class.class), (Type[])new Type[]{Type.getType(String.class)});
    private static final String HASH_CODE_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(Integer.TYPE), (Type[])new Type[0]);
    private static final String EQUALS_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(Boolean.TYPE), (Type[])new Type[]{Type.getType(Object.class)});
    private static final String OBJECT_ARRAY_TYPE = Type.getInternalName(Object[].class);
    private static final String MISSING_METHOD_EXCEPTION_TYPE = Type.getInternalName(MissingMethodException.class);
    private static final String MISSING_PROPERTY_CONSTRUCTOR_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class), Type.getType(Class.class)});
    private static final String METHOD_MISSING_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(String.class), Type.getType(Object.class)});
    private static final String SET_PROPERTY_MISSING_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(String.class), Type.getType(Object.class)});
    private static final String MISSING_METHOD_EXCEPTION_CONSTRUCTOR_DESCRIPTOR = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class), Type.getType(Class.class), Type.getType(Object[].class)});
    private static final Equivalence<Method> METHOD_EQUIVALENCE = new MethodSignatureEquivalence();
    private static final Map<Class<?>, Class<?>> BOXED_TYPES = ImmutableMap.builder().put(Byte.TYPE, Byte.class).put(Short.TYPE, Short.class).put(Integer.TYPE, Integer.class).put(Boolean.TYPE, Boolean.class).put(Float.TYPE, Float.class).put(Character.TYPE, Character.class).put(Double.TYPE, Double.class).put(Long.TYPE, Long.class).build();

    public <T, M extends T, D extends T> Class<? extends M> generate(ModelStructSchema<M> managedSchema, ModelStructSchema<D> delegateSchema) {
        Class superclass;
        if (delegateSchema != null && Modifier.isAbstract(delegateSchema.getType().getConcreteClass().getModifiers())) {
            throw new IllegalArgumentException("Delegate type must be null or a non-abstract type");
        }
        ClassWriter visitor = new ClassWriter(3);
        ModelType managedType = managedSchema.getType();
        StringBuilder generatedTypeNameBuilder = new StringBuilder(managedType.getName());
        if (delegateSchema != null) {
            generatedTypeNameBuilder.append("$BackedBy_").append(delegateSchema.getType().getName().replaceAll("\\.", "_"));
        } else {
            generatedTypeNameBuilder.append("$Impl");
        }
        String generatedTypeName = generatedTypeNameBuilder.toString();
        Type generatedType = Type.getType((String)("L" + generatedTypeName.replaceAll("\\.", "/") + ";"));
        Class managedTypeClass = managedType.getConcreteClass();
        final ImmutableSet.Builder interfaceInternalNames = ImmutableSet.builder();
        final ImmutableSet.Builder typesToDelegate = ImmutableSet.builder();
        typesToDelegate.add(managedTypeClass);
        interfaceInternalNames.add((Object)MANAGED_INSTANCE_TYPE);
        if (managedTypeClass.isInterface()) {
            superclass = Object.class;
            interfaceInternalNames.add((Object)Type.getInternalName(managedTypeClass));
        } else {
            superclass = managedTypeClass;
        }
        if (delegateSchema != null) {
            ModelSchemaUtils.walkTypeHierarchy(delegateSchema.getType().getConcreteClass(), new ModelSchemaUtils.TypeVisitor<D>(){

                @Override
                public void visitType(Class<? super D> type) {
                    if (type.isInterface()) {
                        typesToDelegate.add(type);
                        interfaceInternalNames.add((Object)Type.getInternalName(type));
                    }
                }
            });
        }
        this.generateProxyClass(visitor, managedSchema, delegateSchema, (Collection<String>)interfaceInternalNames.build(), (Set<Class<?>>)typesToDelegate.build(), generatedType, Type.getType(superclass));
        return this.defineClass(visitor, managedTypeClass.getClassLoader(), generatedTypeName);
    }

    private void generateProxyClass(ClassWriter visitor, ModelStructSchema<?> managedSchema, ModelStructSchema<?> delegateSchema, Collection<String> interfaceInternalNames, Set<Class<?>> typesToDelegate, Type generatedType, Type superclassType) {
        ModelType managedType = managedSchema.getType();
        Class managedTypeClass = managedType.getConcreteClass();
        this.declareClass((ClassVisitor)visitor, interfaceInternalNames, generatedType, superclassType);
        this.declareStateField((ClassVisitor)visitor);
        this.declareManagedTypeField((ClassVisitor)visitor);
        this.declareCanCallSettersField((ClassVisitor)visitor);
        this.writeStaticConstructor((ClassVisitor)visitor, generatedType, managedTypeClass);
        this.writeConstructor((ClassVisitor)visitor, generatedType, superclassType, delegateSchema);
        this.writeToString((ClassVisitor)visitor, generatedType, managedTypeClass);
        this.writeManagedInstanceMethods((ClassVisitor)visitor, generatedType);
        if (delegateSchema != null) {
            this.declareDelegateField((ClassVisitor)visitor, delegateSchema);
            this.writeDelegateMethods((ClassVisitor)visitor, generatedType, delegateSchema, typesToDelegate);
        }
        this.writeGroovyMethods((ClassVisitor)visitor, managedTypeClass);
        this.writePropertyMethods((ClassVisitor)visitor, generatedType, managedSchema, delegateSchema);
        this.writeHashCodeMethod((ClassVisitor)visitor, generatedType);
        this.writeEqualsMethod((ClassVisitor)visitor, generatedType);
        visitor.visitEnd();
    }

    private void declareClass(ClassVisitor visitor, Collection<String> interfaceInternalNames, Type generatedType, Type superclassType) {
        visitor.visit(50, 1, generatedType.getInternalName(), null, superclassType.getInternalName(), (String[])Iterables.toArray(interfaceInternalNames, String.class));
    }

    private void declareStateField(ClassVisitor visitor) {
        this.declareField(visitor, STATE_FIELD_NAME, ModelElementState.class);
    }

    private void declareManagedTypeField(ClassVisitor visitor) {
        this.declareStaticField(visitor, MANAGED_TYPE_FIELD_NAME, ModelType.class);
    }

    private void declareDelegateField(ClassVisitor visitor, ModelStructSchema<?> delegateSchema) {
        this.declareField(visitor, DELEGATE_FIELD_NAME, delegateSchema.getType().getConcreteClass());
    }

    private void declareCanCallSettersField(ClassVisitor visitor) {
        this.declareField(visitor, CAN_CALL_SETTERS_FIELD_NAME, Boolean.TYPE);
    }

    private void declareField(ClassVisitor visitor, String name, Class<?> fieldClass) {
        visitor.visitField(2, name, Type.getDescriptor(fieldClass), null, null);
    }

    private FieldVisitor declareStaticField(ClassVisitor visitor, String name, Class<?> fieldClass) {
        return visitor.visitField(10, name, Type.getDescriptor(fieldClass), null, null);
    }

    private void writeConstructor(ClassVisitor visitor, Type generatedType, Type superclassType, ModelStructSchema<?> delegateSchema) {
        String constructorDescriptor;
        Type delegateType;
        if (delegateSchema == null) {
            delegateType = null;
            constructorDescriptor = NO_DELEGATE_CONSTRUCTOR_DESCRIPTOR;
        } else {
            delegateType = Type.getType(delegateSchema.getType().getConcreteClass());
            constructorDescriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{MODEL_ELEMENT_STATE_TYPE, delegateType});
        }
        MethodVisitor constructorVisitor = visitor.visitMethod(1, "<init>", constructorDescriptor, CONCRETE_SIGNATURE, NO_EXCEPTIONS);
        constructorVisitor.visitCode();
        this.invokeSuperConstructor(constructorVisitor, superclassType);
        this.assignStateField(constructorVisitor, generatedType);
        if (delegateType != null) {
            this.assignDelegateField(constructorVisitor, generatedType, delegateType);
        }
        this.setCanCallSettersField(constructorVisitor, generatedType, true);
        this.finishVisitingMethod(constructorVisitor);
    }

    private void writeStaticConstructor(ClassVisitor visitor, Type generatedType, Class<?> managedTypeClass) {
        MethodVisitor constructorVisitor = visitor.visitMethod(8, "<clinit>", "()V", CONCRETE_SIGNATURE, NO_EXCEPTIONS);
        constructorVisitor.visitCode();
        this.writeManagedTypeStaticField(generatedType, managedTypeClass, constructorVisitor);
        this.finishVisitingMethod(constructorVisitor);
    }

    private void writeManagedTypeStaticField(Type generatedType, Class<?> managedTypeClass, MethodVisitor constructorVisitor) {
        constructorVisitor.visitLdcInsn((Object)Type.getType(managedTypeClass));
        constructorVisitor.visitMethodInsn(184, MODELTYPE_INTERNAL_NAME, "of", MODELTYPE_OF_METHOD_DESCRIPTOR, false);
        constructorVisitor.visitFieldInsn(179, generatedType.getInternalName(), MANAGED_TYPE_FIELD_NAME, Type.getDescriptor(ModelType.class));
    }

    private void invokeSuperConstructor(MethodVisitor constructorVisitor, Type superclassType) {
        this.putThisOnStack(constructorVisitor);
        constructorVisitor.visitMethodInsn(183, superclassType.getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), false);
    }

    private void writeToString(ClassVisitor visitor, Type generatedType, Class<?> managedTypeClass) {
        Method toStringMethod = this.getToStringMethod(managedTypeClass);
        if (toStringMethod == null || toStringMethod.getDeclaringClass().equals(Object.class)) {
            this.writeDefaultToString(visitor, generatedType);
        } else {
            this.writeNonAbstractMethodWrapper(visitor, generatedType, managedTypeClass, toStringMethod);
        }
    }

    private void writeDefaultToString(ClassVisitor visitor, Type generatedType) {
        MethodVisitor methodVisitor = visitor.visitMethod(1, "toString", TO_STRING_METHOD_DESCRIPTOR, CONCRETE_SIGNATURE, NO_EXCEPTIONS);
        methodVisitor.visitCode();
        this.putStateFieldValueOnStack(methodVisitor, generatedType);
        methodVisitor.visitMethodInsn(185, MODEL_ELEMENT_STATE_TYPE.getInternalName(), "getDisplayName", TO_STRING_METHOD_DESCRIPTOR, true);
        this.finishVisitingMethod(methodVisitor, 176);
    }

    private Method getToStringMethod(Class<?> managedTypeClass) {
        try {
            return managedTypeClass.getMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private void writeGroovyMethods(ClassVisitor visitor, Class<?> managedTypeClass) {
        MethodVisitor methodVisitor = visitor.visitMethod(1, "propertyMissing", GET_PROPERTY_MISSING_METHOD_DESCRIPTOR, CONCRETE_SIGNATURE, NO_EXCEPTIONS);
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, MISSING_PROPERTY_EXCEPTION_TYPE);
        methodVisitor.visitInsn(89);
        this.putFirstMethodArgumentOnStack(methodVisitor);
        this.putClassOnStack(methodVisitor, managedTypeClass);
        methodVisitor.visitMethodInsn(183, MISSING_PROPERTY_EXCEPTION_TYPE, "<init>", MISSING_PROPERTY_CONSTRUCTOR_DESCRIPTOR, false);
        this.finishVisitingMethod(methodVisitor, 191);
        methodVisitor = visitor.visitMethod(1, "propertyMissing", SET_PROPERTY_MISSING_METHOD_DESCRIPTOR, CONCRETE_SIGNATURE, NO_EXCEPTIONS);
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, MISSING_PROPERTY_EXCEPTION_TYPE);
        methodVisitor.visitInsn(89);
        this.putFirstMethodArgumentOnStack(methodVisitor);
        this.putClassOnStack(methodVisitor, managedTypeClass);
        methodVisitor.visitMethodInsn(183, MISSING_PROPERTY_EXCEPTION_TYPE, "<init>", MISSING_PROPERTY_CONSTRUCTOR_DESCRIPTOR, false);
        this.finishVisitingMethod(methodVisitor, 191);
        methodVisitor = visitor.visitMethod(1, "methodMissing", METHOD_MISSING_METHOD_DESCRIPTOR, CONCRETE_SIGNATURE, NO_EXCEPTIONS);
        methodVisitor.visitCode();
        methodVisitor.visitTypeInsn(187, MISSING_METHOD_EXCEPTION_TYPE);
        methodVisitor.visitInsn(89);
        this.putMethodArgumentOnStack(methodVisitor, 1);
        this.putClassOnStack(methodVisitor, managedTypeClass);
        this.putMethodArgumentOnStack(methodVisitor, 2);
        methodVisitor.visitTypeInsn(192, OBJECT_ARRAY_TYPE);
        methodVisitor.visitMethodInsn(183, MISSING_METHOD_EXCEPTION_TYPE, "<init>", MISSING_METHOD_EXCEPTION_CONSTRUCTOR_DESCRIPTOR, false);
        this.finishVisitingMethod(methodVisitor, 191);
    }

    private void putClassOnStack(MethodVisitor methodVisitor, Class<?> managedTypeClass) {
        this.putConstantOnStack(methodVisitor, managedTypeClass.getName());
        methodVisitor.visitMethodInsn(184, CLASS_TYPE, "forName", FOR_NAME_METHOD_DESCRIPTOR, false);
    }

    private void writeManagedInstanceMethods(ClassVisitor visitor, Type generatedType) {
        this.writeManagedInstanceGetBackingNodeMethod(visitor, generatedType);
        this.writeManagedInstanceGetManagedTypeMethod(visitor, generatedType);
    }

    private void writeManagedInstanceGetBackingNodeMethod(ClassVisitor visitor, Type generatedType) {
        MethodVisitor methodVisitor = visitor.visitMethod(4097, "getBackingNode", GET_BACKING_NODE_METHOD_DESCRIPTOR, CONCRETE_SIGNATURE, NO_EXCEPTIONS);
        methodVisitor.visitCode();
        this.putStateFieldValueOnStack(methodVisitor, generatedType);
        methodVisitor.visitMethodInsn(185, MODEL_ELEMENT_STATE_TYPE.getInternalName(), "getBackingNode", GET_BACKING_NODE_METHOD_DESCRIPTOR, true);
        this.finishVisitingMethod(methodVisitor, 176);
    }

    private void writeManagedInstanceGetManagedTypeMethod(ClassVisitor visitor, Type generatedType) {
        MethodVisitor managedTypeVisitor = visitor.visitMethod(4097, "getManagedType", GET_MANAGED_TYPE_METHOD_DESCRIPTOR, CONCRETE_SIGNATURE, NO_EXCEPTIONS);
        managedTypeVisitor.visitCode();
        this.putManagedTypeFieldValueOnStack(managedTypeVisitor, generatedType);
        this.finishVisitingMethod(managedTypeVisitor, 176);
    }

    private void assignStateField(MethodVisitor constructorVisitor, Type generatedType) {
        this.putThisOnStack(constructorVisitor);
        this.putFirstMethodArgumentOnStack(constructorVisitor);
        constructorVisitor.visitFieldInsn(181, generatedType.getInternalName(), STATE_FIELD_NAME, MODEL_ELEMENT_STATE_TYPE.getDescriptor());
    }

    private void assignDelegateField(MethodVisitor constructorVisitor, Type generatedType, Type delegateType) {
        this.putThisOnStack(constructorVisitor);
        this.putSecondMethodArgumentOnStack(constructorVisitor);
        constructorVisitor.visitFieldInsn(181, generatedType.getInternalName(), DELEGATE_FIELD_NAME, delegateType.getDescriptor());
    }

    private void setCanCallSettersField(MethodVisitor methodVisitor, Type generatedType, boolean canCallSetters) {
        this.putThisOnStack(methodVisitor);
        methodVisitor.visitLdcInsn((Object)canCallSetters);
        methodVisitor.visitFieldInsn(181, generatedType.getInternalName(), CAN_CALL_SETTERS_FIELD_NAME, Type.BOOLEAN_TYPE.getDescriptor());
    }

    private void writePropertyMethods(ClassVisitor visitor, Type generatedType, ModelStructSchema<?> managedSchema, ModelStructSchema<?> delegateSchema) {
        ImmutableSet delegatePropertyNames;
        if (delegateSchema != null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (ModelProperty<?> delegateProperty : delegateSchema.getProperties()) {
                builder.add((Object)delegateProperty.getName());
            }
            delegatePropertyNames = builder.build();
        } else {
            delegatePropertyNames = Collections.emptySet();
        }
        Class managedTypeClass = managedSchema.getType().getConcreteClass();
        for (ModelProperty<?> property : managedSchema.getProperties()) {
            String propertyName = property.getName();
            if (delegatePropertyNames.contains(propertyName)) continue;
            switch (property.getStateManagementType()) {
                case MANAGED: {
                    this.writeGetters(visitor, generatedType, property);
                    this.writeSetter(visitor, generatedType, property);
                    break;
                }
                case UNMANAGED: {
                    Method getterMethod;
                    String getterName = ManagedProxyClassGenerator.getGetterName(propertyName);
                    try {
                        getterMethod = managedTypeClass.getMethod(getterName, new Class[0]);
                    }
                    catch (NoSuchMethodException e) {
                        throw new IllegalStateException(String.format("Cannot find getter '%s' on type %s", getterName, managedTypeClass.getName()), e);
                    }
                    if (Modifier.isFinal(getterMethod.getModifiers()) || propertyName.equals("metaClass")) break;
                    this.writeNonAbstractMethodWrapper(visitor, generatedType, managedTypeClass, getterMethod);
                }
            }
        }
    }

    private void writeSetter(ClassVisitor visitor, Type generatedType, ModelProperty<?> property) {
        WeaklyTypeReferencingMethod<?, Void> weakSetter = property.getSetter();
        if (weakSetter == null) {
            return;
        }
        String propertyName = property.getName();
        Class<?> propertyTypeClass = property.getType().getConcreteClass();
        Label calledOutsideOfConstructor = new Label();
        Method setter = weakSetter.getMethod();
        MethodVisitor methodVisitor = this.declareMethod(visitor, setter.getName(), Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(propertyTypeClass)}), AsmClassGeneratorUtils.signature(setter));
        this.putCanCallSettersFieldValueOnStack(methodVisitor, generatedType);
        this.jumpToLabelIfStackEvaluatesToTrue(methodVisitor, calledOutsideOfConstructor);
        this.throwExceptionBecauseCalledOnItself(methodVisitor);
        methodVisitor.visitLabel(calledOutsideOfConstructor);
        this.putStateFieldValueOnStack(methodVisitor, generatedType);
        this.putConstantOnStack(methodVisitor, propertyName);
        this.putFirstMethodArgumentOnStack(methodVisitor, propertyTypeClass);
        if (propertyTypeClass.isPrimitive()) {
            this.boxType(methodVisitor, propertyTypeClass);
        }
        this.invokeStateSetMethod(methodVisitor);
        this.finishVisitingMethod(methodVisitor);
    }

    private void writeHashCodeMethod(ClassVisitor visitor, Type generatedType) {
        MethodVisitor methodVisitor = visitor.visitMethod(1, "hashCode", HASH_CODE_METHOD_DESCRIPTOR, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, generatedType.getInternalName(), "getBackingNode", GET_BACKING_NODE_METHOD_DESCRIPTOR, false);
        methodVisitor.visitMethodInsn(185, MUTABLE_MODEL_NODE_TYPE, "hashCode", HASH_CODE_METHOD_DESCRIPTOR, true);
        methodVisitor.visitInsn(172);
        this.finishVisitingMethod(methodVisitor, 172);
    }

    private void writeEqualsMethod(ClassVisitor cw, Type generatedType) {
        MethodVisitor methodVisitor = cw.visitMethod(1, "equals", EQUALS_METHOD_DESCRIPTOR, null, null);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitVarInsn(25, 1);
        Label notSameLabel = new Label();
        methodVisitor.visitJumpInsn(166, notSameLabel);
        methodVisitor.visitInsn(4);
        methodVisitor.visitInsn(172);
        methodVisitor.visitLabel(notSameLabel);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(193, MANAGED_INSTANCE_TYPE);
        Label notManagedInstanceLabel = new Label();
        methodVisitor.visitJumpInsn(154, notManagedInstanceLabel);
        methodVisitor.visitInsn(3);
        methodVisitor.visitInsn(172);
        methodVisitor.visitLabel(notManagedInstanceLabel);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(182, generatedType.getInternalName(), "getBackingNode", GET_BACKING_NODE_METHOD_DESCRIPTOR, false);
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitTypeInsn(192, MANAGED_INSTANCE_TYPE);
        methodVisitor.visitMethodInsn(185, MANAGED_INSTANCE_TYPE, "getBackingNode", GET_BACKING_NODE_METHOD_DESCRIPTOR, true);
        methodVisitor.visitMethodInsn(185, MUTABLE_MODEL_NODE_TYPE, "equals", EQUALS_METHOD_DESCRIPTOR, true);
        this.finishVisitingMethod(methodVisitor, 172);
    }

    private void throwExceptionBecauseCalledOnItself(MethodVisitor methodVisitor) {
        String exceptionInternalName = Type.getInternalName(UnsupportedOperationException.class);
        methodVisitor.visitTypeInsn(187, exceptionInternalName);
        methodVisitor.visitInsn(89);
        this.putConstantOnStack(methodVisitor, "Calling setters of a managed type on itself is not allowed");
        String constructorDescriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(String.class)});
        methodVisitor.visitMethodInsn(183, exceptionInternalName, "<init>", constructorDescriptor, false);
        methodVisitor.visitInsn(191);
    }

    private void jumpToLabelIfStackEvaluatesToTrue(MethodVisitor methodVisitor, Label label) {
        methodVisitor.visitJumpInsn(154, label);
    }

    private void invokeStateSetMethod(MethodVisitor methodVisitor) {
        methodVisitor.visitMethodInsn(185, MODEL_ELEMENT_STATE_TYPE.getInternalName(), "set", STATE_SET_METHOD_DESCRIPTOR, true);
    }

    private void putConstantOnStack(MethodVisitor methodVisitor, Object value) {
        methodVisitor.visitLdcInsn(value);
    }

    private MethodVisitor declareMethod(ClassVisitor visitor, Method method) {
        return this.declareMethod(visitor, method.getName(), Type.getMethodDescriptor((Method)method));
    }

    private MethodVisitor declareMethod(ClassVisitor visitor, String methodName, String methodDescriptor) {
        return this.declareMethod(visitor, methodName, methodDescriptor, CONCRETE_SIGNATURE);
    }

    private MethodVisitor declareMethod(ClassVisitor visitor, String methodName, String methodDescriptor, String methodSignature) {
        MethodVisitor methodVisitor = visitor.visitMethod(1, methodName, methodDescriptor, methodSignature, NO_EXCEPTIONS);
        methodVisitor.visitCode();
        return methodVisitor;
    }

    private void putFirstMethodArgumentOnStack(MethodVisitor methodVisitor, Class<?> argType) {
        int loadCode = this.selectOpcode(argType, 25, 21, 22, 23, 24);
        methodVisitor.visitVarInsn(loadCode, 1);
    }

    private int selectOpcode(Class<?> argType, int defaultValue, int intCategoryValue, int longValue, int floatValue, int doubleValue) {
        int code = defaultValue;
        if (argType.isPrimitive()) {
            if (Byte.TYPE == argType || Short.TYPE == argType || Integer.TYPE == argType || Character.TYPE == argType || Boolean.TYPE == argType) {
                code = intCategoryValue;
            } else if (Long.TYPE == argType) {
                code = longValue;
            } else if (Float.TYPE == argType) {
                code = floatValue;
            } else if (Double.TYPE == argType) {
                code = doubleValue;
            }
        }
        return code;
    }

    private void putFirstMethodArgumentOnStack(MethodVisitor methodVisitor) {
        this.putFirstMethodArgumentOnStack(methodVisitor, Object.class);
    }

    private void putSecondMethodArgumentOnStack(MethodVisitor methodVisitor) {
        methodVisitor.visitVarInsn(25, 2);
    }

    private void putMethodArgumentOnStack(MethodVisitor methodVisitor, int index) {
        methodVisitor.visitVarInsn(25, index);
    }

    private void putBooleanMethodArgumentOnStack(MethodVisitor methodVisitor, int index) {
        methodVisitor.visitVarInsn(21, index);
    }

    private void putStateFieldValueOnStack(MethodVisitor methodVisitor, Type generatedType) {
        this.putFieldValueOnStack(methodVisitor, generatedType, STATE_FIELD_NAME, ModelElementState.class);
    }

    private void putManagedTypeFieldValueOnStack(MethodVisitor methodVisitor, Type generatedType) {
        this.putStaticFieldValueOnStack(methodVisitor, generatedType, MANAGED_TYPE_FIELD_NAME, ModelType.class);
    }

    private void putDelegateFieldValueOnStack(MethodVisitor methodVisitor, Type generatedType, Class<?> delegateTypeClass) {
        this.putFieldValueOnStack(methodVisitor, generatedType, DELEGATE_FIELD_NAME, delegateTypeClass);
    }

    private void putCanCallSettersFieldValueOnStack(MethodVisitor methodVisitor, Type generatedType) {
        this.putFieldValueOnStack(methodVisitor, generatedType, CAN_CALL_SETTERS_FIELD_NAME, Boolean.TYPE);
    }

    private void putFieldValueOnStack(MethodVisitor methodVisitor, Type generatedType, String name, Class<?> fieldClass) {
        this.putThisOnStack(methodVisitor);
        methodVisitor.visitFieldInsn(180, generatedType.getInternalName(), name, Type.getDescriptor(fieldClass));
    }

    private void putStaticFieldValueOnStack(MethodVisitor methodVisitor, Type generatedType, String name, Class<?> fieldClass) {
        methodVisitor.visitFieldInsn(178, generatedType.getInternalName(), name, Type.getDescriptor(fieldClass));
    }

    private void writeGetters(ClassVisitor visitor, Type generatedType, ModelProperty<?> property) {
        Class<?> propertyTypeClass = property.getType().getConcreteClass();
        HashSet processedNames = Sets.newHashSet();
        for (WeaklyTypeReferencingMethod<?, ?> weakGetter : property.getGetters()) {
            Method getter = weakGetter.getMethod();
            if (!processedNames.add(getter.getName())) continue;
            MethodVisitor methodVisitor = this.declareMethod(visitor, getter.getName(), Type.getMethodDescriptor((Type)Type.getType(propertyTypeClass), (Type[])new Type[0]), AsmClassGeneratorUtils.signature(getter));
            this.putStateFieldValueOnStack(methodVisitor, generatedType);
            this.putConstantOnStack(methodVisitor, property.getName());
            this.invokeStateGetMethod(methodVisitor);
            this.castFirstStackElement(methodVisitor, propertyTypeClass);
            this.finishVisitingMethod(methodVisitor, this.returnCode(propertyTypeClass));
        }
    }

    private int returnCode(Class<?> propertyTypeClass) {
        return this.selectOpcode(propertyTypeClass, 176, 172, 173, 174, 175);
    }

    private static String getGetterName(String propertyName) {
        return "get" + StringUtils.capitalize((String)propertyName);
    }

    private void castFirstStackElement(MethodVisitor methodVisitor, Class<?> returnType) {
        if (returnType.isPrimitive()) {
            this.unboxType(methodVisitor, returnType);
        } else {
            methodVisitor.visitTypeInsn(192, Type.getInternalName(returnType));
        }
    }

    private void boxType(MethodVisitor methodVisitor, Class<?> primitiveType) {
        Class<?> boxedType = BOXED_TYPES.get(primitiveType);
        methodVisitor.visitMethodInsn(184, Type.getInternalName(boxedType), "valueOf", "(" + Type.getDescriptor(primitiveType) + ")" + Type.getDescriptor(boxedType), false);
    }

    private void unboxType(MethodVisitor methodVisitor, Class<?> primitiveType) {
        Class<?> boxedType = BOXED_TYPES.get(primitiveType);
        methodVisitor.visitTypeInsn(192, Type.getInternalName(boxedType));
        methodVisitor.visitInsn(89);
        Label exit = new Label();
        Label elseValue = new Label();
        methodVisitor.visitJumpInsn(199, elseValue);
        methodVisitor.visitInsn(87);
        this.pushDefaultValue(methodVisitor, primitiveType);
        methodVisitor.visitJumpInsn(167, exit);
        methodVisitor.visitLabel(elseValue);
        methodVisitor.visitMethodInsn(182, Type.getInternalName(boxedType), primitiveType.getSimpleName() + "Value", "()" + Type.getDescriptor(primitiveType), false);
        methodVisitor.visitLabel(exit);
    }

    private void pushDefaultValue(MethodVisitor methodVisitor, Class<?> primitiveType) {
        int ins = 3;
        if (Long.TYPE == primitiveType) {
            ins = 9;
        } else if (Double.TYPE == primitiveType) {
            ins = 14;
        } else if (Float.TYPE == primitiveType) {
            ins = 11;
        }
        methodVisitor.visitInsn(ins);
    }

    private void invokeStateGetMethod(MethodVisitor methodVisitor) {
        String methodDescriptor = Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(String.class)});
        methodVisitor.visitMethodInsn(185, MODEL_ELEMENT_STATE_TYPE.getInternalName(), "get", methodDescriptor, true);
    }

    private void writeNonAbstractMethodWrapper(ClassVisitor visitor, Type generatedType, Class<?> managedTypeClass, Method method) {
        Label start = new Label();
        Label end = new Label();
        Label handler = new Label();
        MethodVisitor methodVisitor = this.declareMethod(visitor, method);
        methodVisitor.visitTryCatchBlock(start, end, handler, null);
        this.setCanCallSettersField(methodVisitor, generatedType, false);
        methodVisitor.visitLabel(start);
        this.invokeSuperMethod(methodVisitor, managedTypeClass, method);
        methodVisitor.visitLabel(end);
        this.setCanCallSettersField(methodVisitor, generatedType, true);
        methodVisitor.visitInsn(176);
        methodVisitor.visitLabel(handler);
        this.setCanCallSettersField(methodVisitor, generatedType, true);
        methodVisitor.visitInsn(191);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private void writeDelegateMethods(ClassVisitor visitor, Type generatedType, ModelStructSchema<?> delegateSchema, Set<Class<?>> typesToDelegate) {
        Class delegateTypeClass = delegateSchema.getType().getConcreteClass();
        HashMap methodsToDelegate = Maps.newHashMap();
        for (Class<?> typeToDelegate : typesToDelegate) {
            for (Method methodToDelegate : typeToDelegate.getMethods()) {
                if (ModelSchemaUtils.isIgnoredMethod(methodToDelegate)) continue;
                Equivalence.Wrapper methodKey = METHOD_EQUIVALENCE.wrap((Object)methodToDelegate);
                Map methodsByReturnType = (Map)methodsToDelegate.get(methodKey);
                if (methodsByReturnType == null) {
                    methodsByReturnType = Maps.newHashMap();
                    methodsToDelegate.put(methodKey, methodsByReturnType);
                }
                methodsByReturnType.put(methodToDelegate.getReturnType(), methodToDelegate);
            }
        }
        ImmutableSet delegateMethodKeys = ImmutableSet.copyOf((Iterable)Iterables.transform(Arrays.asList(delegateTypeClass.getMethods()), (Function)new Function<Method, Equivalence.Wrapper<Method>>(){

            public Equivalence.Wrapper<Method> apply(Method method) {
                return METHOD_EQUIVALENCE.wrap((Object)method);
            }
        }));
        for (Map.Entry entry : methodsToDelegate.entrySet()) {
            Equivalence.Wrapper methodKey = (Equivalence.Wrapper)entry.getKey();
            if (!delegateMethodKeys.contains(methodKey)) continue;
            Map methodsByReturnType = (Map)entry.getValue();
            for (Method methodToDelegate : methodsByReturnType.values()) {
                this.writeDelegatedMethod(visitor, generatedType, delegateTypeClass, methodToDelegate);
            }
        }
    }

    private void writeDelegatedMethod(ClassVisitor visitor, Type generatedType, Class<?> delegateTypeClass, Method method) {
        MethodVisitor methodVisitor = this.declareMethod(visitor, method.getName(), Type.getMethodDescriptor((Method)method), AsmClassGeneratorUtils.signature(method));
        this.invokeDelegateMethod(methodVisitor, generatedType, delegateTypeClass, method);
        Class<?> returnType = method.getReturnType();
        if (returnType == Void.TYPE) {
            this.finishVisitingMethod(methodVisitor);
        } else {
            this.finishVisitingMethod(methodVisitor, this.returnCode(returnType));
        }
    }

    private void invokeDelegateMethod(MethodVisitor methodVisitor, Type generatedType, Class<?> delegateTypeClass, Method method) {
        this.putDelegateFieldValueOnStack(methodVisitor, generatedType, delegateTypeClass);
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int paramNo = 0; paramNo < parameterTypes.length; ++paramNo) {
            if (parameterTypes[paramNo] == Boolean.TYPE) {
                this.putBooleanMethodArgumentOnStack(methodVisitor, paramNo + 1);
                continue;
            }
            this.putMethodArgumentOnStack(methodVisitor, paramNo + 1);
        }
        methodVisitor.visitMethodInsn(182, Type.getInternalName(delegateTypeClass), method.getName(), Type.getMethodDescriptor((Method)method), false);
    }

    private void invokeSuperMethod(MethodVisitor methodVisitor, Class<?> superClass, Method method) {
        this.putThisOnStack(methodVisitor);
        methodVisitor.visitMethodInsn(183, Type.getInternalName(superClass), method.getName(), Type.getMethodDescriptor((Method)method), false);
    }
}

