/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import com.google.common.collect.Lists;
import java.util.Deque;
import org.gradle.api.Nullable;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.NestedModelRuleDescriptor;
import org.gradle.model.internal.core.rule.describe.SimpleModelRuleDescriptor;

public class RuleContext {
    private static final ThreadLocal<Deque<ModelRuleDescriptor>> STACK = new ThreadLocal<Deque<ModelRuleDescriptor>>(){

        @Override
        protected Deque<ModelRuleDescriptor> initialValue() {
            return Lists.newLinkedList();
        }
    };

    @Nullable
    public static ModelRuleDescriptor get() {
        return STACK.get().peek();
    }

    @Nullable
    public static ModelRuleDescriptor nest(ModelRuleDescriptor modelRuleDescriptor) {
        ModelRuleDescriptor parent = RuleContext.get();
        if (parent == null) {
            return modelRuleDescriptor;
        }
        return new NestedModelRuleDescriptor(parent, modelRuleDescriptor);
    }

    @Nullable
    public static ModelRuleDescriptor nest(String modelRuleDescriptor) {
        return RuleContext.nest(new SimpleModelRuleDescriptor(modelRuleDescriptor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(ModelRuleDescriptor descriptor, Runnable runnable) {
        STACK.get().push(descriptor);
        try {
            runnable.run();
        }
        finally {
            STACK.get().pop();
        }
    }
}

