/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.Collections;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;

public class SetJavaScriptEnabledDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create("SetJavaScriptEnabled", "Using `setJavaScriptEnabled`", "Your code should not invoke `setJavaScriptEnabled` if you are not sure that your app really requires JavaScript support.", Category.SECURITY, 6, Severity.WARNING, new Implementation(SetJavaScriptEnabledDetector.class, Scope.JAVA_FILE_SCOPE)).addMoreInfo("http://developer.android.com/guide/practices/security.html");

    @Override
    public void visitMethod(JavaContext context, AstVisitor visitor, MethodInvocation node) {
        if (node.astArguments().size() == 1 && !((Expression)node.astArguments().first()).toString().equals("false")) {
            context.report(ISSUE, (Node)node, context.getLocation((Node)node), "Using `setJavaScriptEnabled` can introduce XSS vulnerabilities into you application, review carefully.");
        }
    }

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("setJavaScriptEnabled");
    }
}

