/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.hprof;

import com.android.tools.perflib.heap.hprof.HprofDumpRecord;
import com.android.tools.perflib.heap.hprof.HprofOutputStream;
import com.android.tools.perflib.heap.hprof.HprofType;
import java.io.IOException;

public class HprofPrimitiveArrayDump
implements HprofDumpRecord {
    public static final byte SUBTAG = 35;
    public final long arrayObjectId;
    public final int stackTraceSerialNumber;
    public final byte elementType;
    public final long[] elements;

    public HprofPrimitiveArrayDump(long arrayObjectId, int stackTraceSerialNumber, byte elementType, long[] elements) {
        this.arrayObjectId = arrayObjectId;
        this.stackTraceSerialNumber = stackTraceSerialNumber;
        this.elementType = elementType;
        this.elements = elements;
    }

    @Override
    public void write(HprofOutputStream hprof) throws IOException {
        hprof.writeU1((byte)35);
        hprof.writeId(this.arrayObjectId);
        hprof.writeU4(this.stackTraceSerialNumber);
        hprof.writeU4(this.elements.length);
        hprof.writeU1(this.elementType);
        for (long element : this.elements) {
            hprof.writeValue(this.elementType, element);
        }
    }

    @Override
    public int getLength(int idSize) {
        return 1 + idSize + 4 + 4 + 1 + this.elements.length * HprofType.sizeOf(this.elementType, idSize);
    }
}

