/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.admin;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.SmartCvsSrcBundle;
import org.netbeans.lib.cvsclient.admin.AdminUtils;
import org.netbeans.lib.cvsclient.admin.DateComparator;
import org.netbeans.lib.cvsclient.admin.EntriesHandler;
import org.netbeans.lib.cvsclient.admin.Entry;
import org.netbeans.lib.cvsclient.admin.IAdminReader;
import org.netbeans.lib.cvsclient.file.AbstractFileObject;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.file.FileObject;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.lib.cvsclient.file.ICvsFileSystem;
import org.netbeans.lib.cvsclient.util.BugLog;

public final class AdminReader
implements IAdminReader {
    private final String myCharset;
    @NonNls
    private static final String CVS_REPOSITORY_FILE_PATH = "CVS/Repository";
    @NonNls
    private static final String CVS_DIR_NAME = "CVS";
    @NonNls
    private static final String CVS_ENTRIES_STATIC_FILE_PATH = "CVS/Entries.Static";
    @NonNls
    private static final String CVS_ROOT_FILE_PATH = "CVS/Root";

    public AdminReader(String charset) {
        this.myCharset = charset;
    }

    public Entry getEntry(AbstractFileObject fileObject, ICvsFileSystem cvsFileSystem) throws IOException {
        File directory = cvsFileSystem.getAdminFileSystem().getFile((AbstractFileObject)fileObject.getParent());
        try {
            EntriesHandler entriesHandler = new EntriesHandler(directory);
            entriesHandler.read(this.myCharset);
            return entriesHandler.getEntries().getEntry(fileObject.getName());
        }
        catch (FileNotFoundException ex) {
            return null;
        }
    }

    public Collection getEntries(DirectoryObject directoryObject, ICvsFileSystem cvsFileSystem) throws IOException {
        File directory = cvsFileSystem.getAdminFileSystem().getFile((AbstractFileObject)directoryObject);
        try {
            EntriesHandler entriesHandler = new EntriesHandler(directory);
            entriesHandler.read(this.myCharset);
            return entriesHandler.getEntries().getEntries();
        }
        catch (FileNotFoundException ex) {
            return Collections.emptySet();
        }
    }

    public String getRepositoryForDirectory(DirectoryObject directoryObject, String repository, ICvsFileSystem cvsFileSystem) throws IOException {
        File repositoryFile;
        File directory = cvsFileSystem.getAdminFileSystem().getFile((AbstractFileObject)directoryObject);
        String repositoryDirs = "";
        File dirFile = directory;
        while (true) {
            if (dirFile == null || dirFile.getName().length() == 0 || !dirFile.exists()) {
                throw new FileNotFoundException(SmartCvsSrcBundle.message("repository.file.not.found.for.directory.error.message", directory));
            }
            repositoryFile = new File(dirFile, CVS_REPOSITORY_FILE_PATH);
            if (repositoryFile.exists()) break;
            repositoryDirs = '/' + dirFile.getName() + repositoryDirs;
            dirFile = dirFile.getParentFile();
        }
        String fileRepository = FileUtils.readLineFromFile((File)repositoryFile);
        if (fileRepository == null) {
            fileRepository = "";
        }
        fileRepository = fileRepository + repositoryDirs;
        if ((fileRepository = fileRepository.replace(File.separatorChar, '/')).startsWith(repository)) {
            return fileRepository;
        }
        return FileUtils.ensureTrailingSlash((String)repository) + fileRepository;
    }

    public String getStickyTagForDirectory(DirectoryObject directoryObject, ICvsFileSystem cvsFileSystem) {
        return AdminUtils.getStickyTagForDirectory(directoryObject, cvsFileSystem);
    }

    public boolean hasCvsDirectory(DirectoryObject directoryObject, ICvsFileSystem cvsFileSystem) {
        BugLog.getInstance().assertNotNull((Object)directoryObject);
        BugLog.getInstance().assertNotNull((Object)cvsFileSystem);
        File directory = cvsFileSystem.getAdminFileSystem().getFile((AbstractFileObject)directoryObject);
        return new File(directory, CVS_DIR_NAME).isDirectory();
    }

    public boolean isModified(FileObject fileObject, Date entryLastModified, ICvsFileSystem cvsFileSystem) {
        File file = cvsFileSystem.getLocalFileSystem().getFile((AbstractFileObject)fileObject);
        return !DateComparator.getInstance().equals(file.lastModified(), entryLastModified.getTime());
    }

    public boolean isStatic(DirectoryObject directoryObject, ICvsFileSystem cvsFileSystem) {
        BugLog.getInstance().assertNotNull((Object)directoryObject);
        BugLog.getInstance().assertNotNull((Object)cvsFileSystem);
        File directory = cvsFileSystem.getAdminFileSystem().getFile((AbstractFileObject)directoryObject);
        return new File(directory, CVS_ENTRIES_STATIC_FILE_PATH).isFile();
    }

    public String getCvsRootForDirectory(DirectoryObject directoryObject, ICvsFileSystem cvsFileSystem) throws IOException {
        File rootFile;
        File directory = cvsFileSystem.getAdminFileSystem().getFile((AbstractFileObject)directoryObject);
        String repositoryDirs = "";
        File dirFile = directory;
        while (true) {
            if (dirFile == null || dirFile.getName().length() == 0 || !dirFile.exists()) {
                throw new FileNotFoundException(SmartCvsSrcBundle.message("root.file.not.found.for.directory.err.rmessage", directory));
            }
            rootFile = new File(dirFile, CVS_ROOT_FILE_PATH);
            if (rootFile.exists()) break;
            repositoryDirs = '/' + dirFile.getName() + repositoryDirs;
            dirFile = dirFile.getParentFile();
        }
        return FileUtils.readLineFromFile((File)rootFile).trim();
    }
}

