/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.structure.reflect;

import java.lang.reflect.Array;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

public final class ReflectClassUtilKt {
    @NotNull
    public static final ClassLoader getSafeClassLoader(Class<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassLoader classLoader = $receiver.getClassLoader();
        if (classLoader == null) {
            ClassLoader classLoader2 = ClassLoader.getSystemClassLoader();
            classLoader = classLoader2;
            Intrinsics.checkExpressionValueIsNotNull(classLoader2, "ClassLoader.getSystemClassLoader()");
        }
        return classLoader;
    }

    public static final boolean isEnumClassOrSpecializedEnumEntryClass(Class<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return Enum.class.isAssignableFrom($receiver);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static final ClassId getClassId(Class<?> $receiver) {
        Class<?> clazz;
        block7: {
            block6: {
                Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                if ($receiver.isPrimitive()) {
                    throw (Throwable)new IllegalArgumentException("Can't compute ClassId for primitive type: " + $receiver);
                }
                if ($receiver.isArray()) {
                    throw (Throwable)new IllegalArgumentException("Can't compute ClassId for array type: " + $receiver);
                }
                if ($receiver.getEnclosingMethod() != null || $receiver.getEnclosingConstructor() != null) break block6;
                CharSequence $receiver$iv = $receiver.getSimpleName();
                if (!($receiver$iv.length() == 0)) break block7;
            }
            FqName fqName2 = new FqName($receiver.getName());
            clazz = new ClassId(fqName2.parent(), FqName.topLevel(fqName2.shortName()), true);
            return clazz;
        }
        clazz = $receiver.getDeclaringClass();
        if (clazz != null && (clazz = ReflectClassUtilKt.getClassId(clazz)) != null && (clazz = ((ClassId)((Object)clazz)).createNestedClassId(Name.identifier($receiver.getSimpleName()))) != null) {
            return clazz;
        }
        ClassId classId = ClassId.topLevel(new FqName($receiver.getName()));
        clazz = classId;
        Intrinsics.checkExpressionValueIsNotNull(classId, "ClassId.topLevel(FqName(name))");
        return clazz;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getDesc(Class<?> $receiver) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if (Intrinsics.areEqual($receiver, Void.TYPE)) {
            return "V";
        }
        String string = ReflectClassUtilKt.createArrayType($receiver).getName();
        int startIndex$iv = 1;
        void v0 = $receiver$iv;
        if (v0 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = ((String)v0).substring(startIndex$iv);
        Intrinsics.checkExpressionValueIsNotNull(string2, "(this as java.lang.String).substring(startIndex)");
        return StringsKt.replace$default(string2, '.', '/', false, 4, null);
    }

    @NotNull
    public static final Class<?> createArrayType(Class<?> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return Array.newInstance($receiver, 0).getClass();
    }
}

