/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotated;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.serialization.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.Deserialization;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationContext;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedType;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.FlexibleTypeCapabilitiesDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.LocalClassResolver;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoTypeTableUtilKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedTypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.storage.NotNullLazyValue;
import kotlin.reflect.jvm.internal.impl.types.DelegatingFlexibleType;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypeCapabilities;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeBasedStarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeDeserializer {
    private final Function1<Integer, ClassDescriptor> classDescriptors;
    private final NotNullLazyValue<Map<Integer, TypeParameterDescriptor>> typeParameterDescriptors;
    private final DeserializationContext c;
    private final TypeDeserializer parent;
    private final List<ProtoBuf.TypeParameter> typeParameterProtos;
    private final String debugName;

    @NotNull
    public final List<TypeParameterDescriptor> getOwnTypeParameters() {
        return kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.toReadOnlyList(((Map)this.typeParameterDescriptors.invoke()).values());
    }

    @NotNull
    public final KotlinType type(@NotNull ProtoBuf.Type proto, @NotNull Annotations additionalAnnotations) {
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(additionalAnnotations, "additionalAnnotations");
        if (proto.hasFlexibleTypeCapabilitiesId()) {
            String id = this.c.getNameResolver().getString(proto.getFlexibleTypeCapabilitiesId());
            FlexibleTypeCapabilitiesDeserializer flexibleTypeCapabilitiesDeserializer = this.c.getComponents().getFlexibleTypeCapabilitiesDeserializer();
            String string = id;
            Intrinsics.checkExpressionValueIsNotNull(string, "id");
            FlexibleTypeCapabilities flexibleTypeCapabilities = flexibleTypeCapabilitiesDeserializer.capabilitiesById(string);
            if (flexibleTypeCapabilities == null) {
                KotlinType kotlinType = ErrorUtils.createErrorType(new DeserializedType(this.c, proto, null, 4, null) + ": Capabilities not found for id " + id);
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "ErrorUtils.createErrorTy\u2026es not found for id $id\")");
                return kotlinType;
            }
            FlexibleTypeCapabilities capabilities = flexibleTypeCapabilities;
            KotlinType kotlinType = new DeserializedType(this.c, proto, null, 4, null);
            ProtoBuf.Type type2 = ProtoTypeTableUtilKt.flexibleUpperBound(proto, this.c.getTypeTable());
            if (type2 == null) {
                Intrinsics.throwNpe();
            }
            return DelegatingFlexibleType.Companion.create(kotlinType, new DeserializedType(this.c, type2, null, 4, null), capabilities);
        }
        return new DeserializedType(this.c, proto, additionalAnnotations);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ KotlinType type$default(TypeDeserializer typeDeserializer, ProtoBuf.Type type2, Annotations annotations2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: type");
        }
        if ((n & 2) != 0) {
            annotations2 = Annotations.Companion.getEMPTY();
        }
        return typeDeserializer.type(type2, annotations2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TypeConstructor typeConstructor(@NotNull ProtoBuf.Type proto) {
        TypeConstructor typeConstructor2;
        Annotated annotated;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        if (proto.hasClassName()) {
            ClassDescriptor classDescriptor = this.classDescriptors.invoke(proto.getClassName());
            annotated = classDescriptor != null ? classDescriptor.getTypeConstructor() : null;
        } else if (proto.hasTypeParameter()) {
            annotated = this.typeParameterTypeConstructor(proto.getTypeParameter());
        } else if (proto.hasTypeParameterName()) {
            TypeParameterDescriptor parameter;
            Object v5;
            String name;
            DeclarationDescriptor container;
            block13: {
                void $receiver$iv$iv;
                void $receiver$iv;
                List<Object> list;
                container = this.c.getContainingDeclaration();
                DeclarationDescriptor declarationDescriptor = container;
                if (declarationDescriptor instanceof ClassDescriptor) {
                    List<TypeParameterDescriptor> list2 = ((ClassDescriptor)container).getTypeConstructor().getParameters();
                    list = list2;
                    Intrinsics.checkExpressionValueIsNotNull(list2, "container.typeConstructor.parameters");
                } else if (declarationDescriptor instanceof CallableDescriptor) {
                    List<TypeParameterDescriptor> list3 = ((CallableDescriptor)container).getTypeParameters();
                    list = list3;
                    Intrinsics.checkExpressionValueIsNotNull(list3, "container.typeParameters");
                } else {
                    list = CollectionsKt.emptyList();
                }
                List<Object> typeParameters = list;
                name = this.c.getNameResolver().getString(proto.getTypeParameterName());
                Iterable iterable = typeParameters;
                void var6_6 = $receiver$iv;
                for (Object element$iv$iv : $receiver$iv$iv) {
                    TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv$iv;
                    if (!Intrinsics.areEqual(it.getName().asString(), name)) continue;
                    v5 = element$iv$iv;
                    break block13;
                }
                v5 = null;
            }
            if ((annotated = (parameter = (TypeParameterDescriptor)v5)) == null || (annotated = annotated.getTypeConstructor()) == null) {
                annotated = ErrorUtils.createErrorType("Deserialized type parameter " + name + " in " + container).getConstructor();
            }
        } else {
            annotated = typeConstructor2 = (TypeConstructor)null;
        }
        if (annotated == null) {
            TypeConstructor typeConstructor3 = ErrorUtils.createErrorType(this.presentableTextForErrorType$kotlin_core(proto)).getConstructor();
            typeConstructor2 = typeConstructor3;
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor3, "ErrorUtils.createErrorTy\u2026rType(proto)).constructor");
        }
        return typeConstructor2;
    }

    @NotNull
    public final String presentableTextForErrorType$kotlin_core(@NotNull ProtoBuf.Type proto) {
        String string;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        if (proto.hasClassName()) {
            String string2 = this.c.getNameResolver().getClassId(proto.getClassName()).asSingleFqName().asString();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull(string2, "c.nameResolver.getClassI\u2026SingleFqName().asString()");
        } else {
            string = proto.hasTypeParameter() ? "Unknown type parameter " + proto.getTypeParameter() : (proto.hasTypeParameterName() ? "Unknown type parameter " + this.c.getNameResolver().getString(proto.getTypeParameterName()) : "Unknown type");
        }
        return string;
    }

    private final TypeConstructor typeParameterTypeConstructor(int typeParameterId) {
        Annotated annotated = (TypeParameterDescriptor)((Map)this.typeParameterDescriptors.invoke()).get(typeParameterId);
        if (annotated == null || (annotated = annotated.getTypeConstructor()) == null) {
            TypeDeserializer typeDeserializer = this.parent;
            annotated = typeDeserializer != null ? typeDeserializer.typeParameterTypeConstructor(typeParameterId) : null;
        }
        return annotated;
    }

    private final ClassDescriptor computeClassDescriptor(int fqNameIndex) {
        ClassId id = this.c.getNameResolver().getClassId(fqNameIndex);
        if (id.isLocal()) {
            LocalClassResolver localClassResolver = this.c.getComponents().getLocalClassResolver();
            ClassId classId = id;
            Intrinsics.checkExpressionValueIsNotNull(classId, "id");
            return localClassResolver.resolveLocalClass(classId);
        }
        ModuleDescriptor moduleDescriptor = this.c.getComponents().getModuleDescriptor();
        ClassId classId = id;
        Intrinsics.checkExpressionValueIsNotNull(classId, "id");
        return FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, classId);
    }

    @NotNull
    public final TypeProjection typeArgument(@Nullable TypeParameterDescriptor parameter, @NotNull ProtoBuf.Type.Argument typeArgumentProto) {
        Intrinsics.checkParameterIsNotNull(typeArgumentProto, "typeArgumentProto");
        if (Intrinsics.areEqual(typeArgumentProto.getProjection(), ProtoBuf.Type.Argument.Projection.STAR)) {
            TypeProjection typeProjection;
            if (parameter == null) {
                KotlinType kotlinType = this.c.getComponents().getModuleDescriptor().getBuiltIns().getNullableAnyType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "c.components.moduleDescr\u2026.builtIns.nullableAnyType");
                typeProjection = new TypeBasedStarProjectionImpl(kotlinType);
            } else {
                typeProjection = new StarProjectionImpl(parameter);
            }
            return typeProjection;
        }
        ProtoBuf.Type.Argument.Projection projection = typeArgumentProto.getProjection();
        Intrinsics.checkExpressionValueIsNotNull(projection, "typeArgumentProto.projection");
        Variance variance = Deserialization.variance(projection);
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.type(typeArgumentProto, this.c.getTypeTable());
        if (type2 == null) {
            return new TypeProjectionImpl(ErrorUtils.createErrorType("No type recorded"));
        }
        ProtoBuf.Type type3 = type2;
        return new TypeProjectionImpl(variance, TypeDeserializer.type$default(this, type3, null, 2, null));
    }

    @NotNull
    public String toString() {
        return this.debugName + (this.parent == null ? "" : ". Child of " + this.parent.debugName);
    }

    public TypeDeserializer(@NotNull DeserializationContext c, @Nullable TypeDeserializer parent, @NotNull List<ProtoBuf.TypeParameter> typeParameterProtos, @NotNull String debugName) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(typeParameterProtos, "typeParameterProtos");
        Intrinsics.checkParameterIsNotNull(debugName, "debugName");
        this.c = c;
        this.parent = parent;
        this.typeParameterProtos = typeParameterProtos;
        this.debugName = debugName;
        this.classDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<Integer, ClassDescriptor>(this){
            final /* synthetic */ TypeDeserializer this$0;

            @Nullable
            public final ClassDescriptor invoke(int fqNameIndex) {
                return TypeDeserializer.access$computeClassDescriptor(this.this$0, fqNameIndex);
            }
            {
                this.this$0 = typeDeserializer;
                super(1);
            }
        });
        this.typeParameterDescriptors = this.c.getStorageManager().createLazyValue((Function0)new Function0<Map<Integer, ? extends TypeParameterDescriptor>>(this){
            final /* synthetic */ TypeDeserializer this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Map<Integer, TypeParameterDescriptor> invoke() {
                Map map2;
                if (TypeDeserializer.access$getTypeParameterProtos$p(this.this$0).isEmpty()) {
                    map2 = MapsKt.emptyMap();
                } else {
                    LinkedHashMap<K, V> result = new LinkedHashMap<K, V>();
                    for (IndexedValue<T> indexedValue : CollectionsKt.withIndex(TypeDeserializer.access$getTypeParameterProtos$p(this.this$0))) {
                        void value$iv;
                        void key$iv;
                        void $receiver$iv;
                        int index = indexedValue.component1();
                        ProtoBuf.TypeParameter proto = (ProtoBuf.TypeParameter)indexedValue.component2();
                        Map map3 = result;
                        Integer n = proto.getId();
                        DeserializedTypeParameterDescriptor deserializedTypeParameterDescriptor = new DeserializedTypeParameterDescriptor(TypeDeserializer.access$getC$p(this.this$0), proto, index);
                        $receiver$iv.put(key$iv, value$iv);
                    }
                    map2 = result;
                }
                return map2;
            }
            {
                this.this$0 = typeDeserializer;
                super(0);
            }
        });
    }

    @Nullable
    public static final /* synthetic */ ClassDescriptor access$computeClassDescriptor(TypeDeserializer $this, int fqNameIndex) {
        return $this.computeClassDescriptor(fqNameIndex);
    }

    @NotNull
    public static final /* synthetic */ List access$getTypeParameterProtos$p(TypeDeserializer $this) {
        return $this.typeParameterProtos;
    }

    @NotNull
    public static final /* synthetic */ DeserializationContext access$getC$p(TypeDeserializer $this) {
        return $this.c;
    }
}

