/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.name;

import hidden.org.apache.jackrabbit.name.GenerationalCache;
import hidden.org.apache.jackrabbit.name.NameException;
import hidden.org.apache.jackrabbit.name.Path;
import hidden.org.apache.jackrabbit.name.PathResolver;
import javax.jcr.NamespaceException;

public class CachingPathResolver
implements PathResolver {
    private final PathResolver resolver;
    private final GenerationalCache cache;

    public CachingPathResolver(PathResolver resolver, GenerationalCache cache) {
        this.resolver = resolver;
        this.cache = cache;
    }

    public CachingPathResolver(PathResolver resolver) {
        this(resolver, new GenerationalCache());
    }

    public Path getQPath(String path) throws NameException, NamespaceException {
        Path qpath = (Path)this.cache.get(path);
        if (qpath == null) {
            qpath = this.resolver.getQPath(path);
            this.cache.put(path, qpath);
        }
        return qpath;
    }

    public String getJCRPath(Path qpath) throws NamespaceException {
        String path = (String)this.cache.get(qpath);
        if (path == null) {
            path = this.resolver.getJCRPath(qpath);
            this.cache.put(qpath, path);
        }
        return path;
    }
}

