/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.util;

import java.util.Collection;
import java.util.StringTokenizer;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.util.TraversingItemVisitor;

public class ChildrenCollectorFilter
extends TraversingItemVisitor.Default {
    static final char WILDCARD_CHAR = '*';
    static final String OR = "|";
    private final Collection children;
    private final boolean collectNodes;
    private final boolean collectProperties;
    private final String namePattern;

    public ChildrenCollectorFilter(String namePattern, Collection children, boolean collectNodes, boolean collectProperties, int maxLevel) {
        super(false, maxLevel);
        this.namePattern = namePattern;
        this.children = children;
        this.collectNodes = collectNodes;
        this.collectProperties = collectProperties;
    }

    protected void entering(Node node, int level) throws RepositoryException {
        if (level > 0 && this.collectNodes && ChildrenCollectorFilter.matches(node.getName(), this.namePattern)) {
            this.children.add(node);
        }
    }

    protected void entering(Property property, int level) throws RepositoryException {
        if (level > 0 && this.collectProperties && ChildrenCollectorFilter.matches(property.getName(), this.namePattern)) {
            this.children.add(property);
        }
    }

    public static boolean matches(String name, String pattern) {
        StringTokenizer st = new StringTokenizer(pattern, OR, false);
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (!ChildrenCollectorFilter.internalMatches(name, token, 0, 0)) continue;
            return true;
        }
        return false;
    }

    private static boolean internalMatches(String s, String pattern, int sOff, int pOff) {
        int pLen = pattern.length();
        int sLen = s.length();
        while (true) {
            if (pOff >= pLen) {
                if (sOff >= sLen) {
                    return true;
                }
                return s.charAt(sOff) == '[';
            }
            if (sOff >= sLen && pattern.charAt(pOff) != '*') {
                return false;
            }
            if (pattern.charAt(pOff) == '*') {
                if (++pOff >= pLen) {
                    return true;
                }
                while (true) {
                    if (ChildrenCollectorFilter.internalMatches(s, pattern, sOff, pOff)) {
                        return true;
                    }
                    if (sOff >= sLen) {
                        return false;
                    }
                    ++sOff;
                }
            }
            if (pOff < pLen && sOff < sLen && pattern.charAt(pOff) != s.charAt(sOff)) {
                return false;
            }
            ++pOff;
            ++sOff;
        }
    }
}

