/*
 * Decompiled with CFR 0.152.
 */
package hidden.org.apache.jackrabbit.webdav.header;

import hidden.org.apache.jackrabbit.webdav.header.Header;
import hidden.org.slf4j.Logger;
import hidden.org.slf4j.LoggerFactory;
import javax.servlet.http.HttpServletRequest;

public class OverwriteHeader
implements Header {
    private static Logger log = LoggerFactory.getLogger(OverwriteHeader.class);
    public static final String OVERWRITE_TRUE = "T";
    public static final String OVERWRITE_FALSE = "F";
    private final boolean doOverwrite;

    public OverwriteHeader(boolean doOverwrite) {
        this.doOverwrite = doOverwrite;
    }

    public OverwriteHeader(HttpServletRequest request) {
        String overwriteHeader = request.getHeader("Overwrite");
        this.doOverwrite = overwriteHeader != null ? overwriteHeader.equalsIgnoreCase(OVERWRITE_TRUE) : true;
    }

    public String getHeaderName() {
        return "Overwrite";
    }

    public String getHeaderValue() {
        return this.doOverwrite ? OVERWRITE_TRUE : OVERWRITE_FALSE;
    }

    public boolean isOverwrite() {
        return this.doOverwrite;
    }
}

