/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.PrintStream;
import org.apache.maven.wagon.events.TransferEvent;
import org.apache.maven.wagon.events.TransferListener;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;

public abstract class AbstractConsoleDownloadMonitor
extends AbstractLogEnabled
implements TransferListener {
    private Logger logger;
    PrintStream out = System.out;

    public AbstractConsoleDownloadMonitor() {
    }

    public AbstractConsoleDownloadMonitor(Logger logger) {
        this.logger = logger;
    }

    public void transferInitiated(TransferEvent transferEvent) {
        String message = transferEvent.getRequestType() == 6 ? "Uploading" : "Downloading";
        String url = transferEvent.getWagon().getRepository().getUrl();
        this.out.println(message + ": " + url + "/" + transferEvent.getResource().getName());
    }

    public void transferStarted(TransferEvent transferEvent) {
    }

    public void transferProgress(TransferEvent transferEvent, byte[] buffer, int length) {
    }

    public void transferCompleted(TransferEvent transferEvent) {
        String line = this.createCompletionLine(transferEvent);
        this.out.println(line);
    }

    protected String createCompletionLine(TransferEvent transferEvent) {
        String line;
        long contentLength = transferEvent.getResource().getContentLength();
        if (contentLength != -1L) {
            StringBuffer buf = new StringBuffer();
            String type = transferEvent.getRequestType() == 6 ? "uploaded" : "downloaded";
            buf.append(contentLength >= 1024L ? contentLength / 1024L + "K" : contentLength + "b");
            String name = transferEvent.getResource().getName();
            name = name.substring(name.lastIndexOf(47) + 1, name.length());
            buf.append(" ");
            buf.append(type);
            buf.append("  (");
            buf.append(name);
            buf.append(")");
            line = buf.toString();
        } else {
            line = "";
        }
        return line;
    }

    public void transferError(TransferEvent transferEvent) {
        if (this.logger != null) {
            Exception exception = transferEvent.getException();
            this.logger.debug(exception.getMessage(), exception);
        }
    }

    public void debug(String message) {
        if (this.logger != null) {
            this.logger.debug(message);
        }
    }
}

