/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ws.wadl2java;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JVar;
import java.util.Arrays;
import java.util.HashSet;
import javax.xml.namespace.QName;
import org.jvnet.ws.wadl.Option;
import org.jvnet.ws.wadl.Param;
import org.jvnet.ws.wadl2java.JavaDocUtil;

public class GeneratorUtil {
    private static HashSet<String> keywords = new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"));

    public static String makeConstantName(String input) {
        char firstChar;
        if (input == null || input.length() == 0) {
            input = "CONSTANT";
        }
        if ((firstChar = input.charAt(0)) >= '0' && firstChar <= '9') {
            input = "V_" + input;
        }
        input = input.replaceAll("\\W", "_");
        input = input.toUpperCase();
        return input;
    }

    public static String makeClassName(String input) {
        if (input == null || input.length() == 0) {
            return "Index";
        }
        StringBuffer buf = new StringBuffer();
        for (String segment : input.split("[^a-zA-Z0-9]")) {
            if (segment.length() < 1) continue;
            buf.append(segment.substring(0, 1).toUpperCase());
            buf.append(segment.substring(1));
        }
        return buf.toString();
    }

    public static String makeParamName(String input) {
        if (input == null || input.length() == 0) {
            return "param";
        }
        StringBuffer buf = new StringBuffer();
        boolean firstSegment = true;
        for (String segment : input.split("[^a-zA-Z0-9]")) {
            if (segment.length() < 1) continue;
            if (firstSegment) {
                buf.append(segment.toLowerCase());
                firstSegment = false;
                continue;
            }
            buf.append(segment.substring(0, 1).toUpperCase());
            buf.append(segment.substring(1));
        }
        String paramName = buf.toString();
        if (keywords.contains(paramName)) {
            return "_" + paramName;
        }
        return paramName;
    }

    public static JClass getJavaType(Param param, JCodeModel model, JDefinedClass parentClass, JavaDocUtil javaDoc) {
        if (param.getOption().size() > 0) {
            JDefinedClass $enum;
            try {
                $enum = parentClass._package()._enum(GeneratorUtil.makeClassName(param.getName()));
                javaDoc.generateEnumDoc(param, $enum);
                for (Option o : param.getOption()) {
                    JEnumConstant c = $enum.enumConstant(GeneratorUtil.makeConstantName(o.getValue()));
                    c.arg(JExpr.lit((String)o.getValue()));
                    javaDoc.generateEnumConstantDoc(o, c);
                }
                JFieldVar $stringVal = $enum.field(4, String.class, "stringVal");
                JMethod $ctor = $enum.constructor(4);
                JVar $val = $ctor.param(String.class, "v");
                $ctor.body().assign((JAssignmentTarget)$stringVal, (JExpression)$val);
                JMethod $toString = $enum.method(1, String.class, "toString");
                $toString.body()._return((JExpression)$stringVal);
            }
            catch (JClassAlreadyExistsException ex) {
                $enum = ex.getExistingClass();
            }
            return $enum;
        }
        Class type = String.class;
        QName xmlType = param.getType();
        if (xmlType != null && xmlType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
            String localPart = xmlType.getLocalPart();
            if (localPart.equals("boolean")) {
                type = Boolean.class;
            } else if (localPart.equals("integer")) {
                type = Integer.class;
            } else if (localPart.equals("nonPositiveInteger")) {
                type = Integer.class;
            } else if (localPart.equals("long")) {
                type = Long.class;
            } else if (localPart.equals("nonNegativeInteger")) {
                type = Integer.class;
            } else if (localPart.equals("negativeInteger")) {
                type = Integer.class;
            } else if (localPart.equals("int")) {
                type = Integer.class;
            } else if (localPart.equals("unsignedLong")) {
                type = Long.class;
            } else if (localPart.equals("positiveInteger")) {
                type = Integer.class;
            } else if (localPart.equals("unsignedInt")) {
                type = Integer.class;
            } else if (localPart.equals("unsignedShort")) {
                type = Integer.class;
            } else if (localPart.equals("unsignedByte")) {
                type = Byte.class;
            } else if (localPart.equals("int")) {
                type = Integer.class;
            } else if (localPart.equals("short")) {
                type = Integer.class;
            } else if (localPart.equals("byte")) {
                type = Byte.class;
            } else if (localPart.equals("float")) {
                type = Float.class;
            } else if (localPart.equals("double")) {
                type = Double.class;
            } else if (localPart.equals("decimal")) {
                type = Double.class;
            } else if (localPart.equals("QName")) {
                type = QName.class;
            }
        }
        return (JClass)model._ref(type);
    }
}

