/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.ws.wadl2java.ast;

import com.sun.codemodel.JDefinedClass;
import java.util.ArrayList;
import java.util.List;
import org.jvnet.ws.wadl.Doc;
import org.jvnet.ws.wadl.Param;
import org.jvnet.ws.wadl.ResourceType;
import org.jvnet.ws.wadl2java.GeneratorUtil;
import org.jvnet.ws.wadl2java.ast.MethodNode;
import org.jvnet.ws.wadl2java.ast.PathSegment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceTypeNode {
    private String interfaceName;
    private List<MethodNode> methods;
    private PathSegment pathSegment;
    private List<Doc> doc;
    private JDefinedClass generatedInterface;

    public ResourceTypeNode(ResourceType resourceType) {
        this.doc = resourceType.getDoc();
        this.pathSegment = new PathSegment(resourceType);
        this.interfaceName = GeneratorUtil.makeClassName(resourceType.getId());
        this.methods = new ArrayList<MethodNode>();
        this.generatedInterface = null;
    }

    public String getClassName() {
        return this.interfaceName;
    }

    public List<MethodNode> getMethods() {
        return this.methods;
    }

    public List<Param> getQueryParams() {
        return this.pathSegment.getQueryParameters();
    }

    public List<Param> getHeaderParams() {
        return this.pathSegment.getHeaderParameters();
    }

    public List<Param> getMatrixParams() {
        return this.pathSegment.getMatrixParameters();
    }

    public List<Doc> getDoc() {
        return this.doc;
    }

    public void setGeneratedInterface(JDefinedClass iface) {
        this.generatedInterface = iface;
    }

    public JDefinedClass getGeneratedInterface() {
        return this.generatedInterface;
    }
}

