/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxControllerBasedReferenceProvider;

public class JavaFxFieldIdReferenceProvider
extends JavaFxControllerBasedReferenceProvider {
    @Override
    protected PsiReference[] getReferencesByElement(@NotNull PsiClass aClass, XmlAttributeValue xmlAttributeValue, ProcessingContext context) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxFieldIdReferenceProvider", "getReferencesByElement"));
        }
        String name = xmlAttributeValue.getValue();
        PsiField fieldOrGetterMethod = aClass.findFieldByName(name, true);
        if (fieldOrGetterMethod == null) {
            PsiMethod[] methods;
            for (PsiMethod method : methods = aClass.findMethodsByName(name, true)) {
                if (method.getParameterList().getParameters().length != 0) continue;
                fieldOrGetterMethod = method;
                break;
            }
        }
        return new PsiReference[]{new JavaFxControllerFieldRef(xmlAttributeValue, (PsiMember)fieldOrGetterMethod, aClass)};
    }

    public static class JavaFxControllerFieldRef
    extends PsiReferenceBase<XmlAttributeValue> {
        private final XmlAttributeValue myXmlAttributeValue;
        private final PsiMember myFieldOrMethod;
        private final PsiClass myAClass;

        public JavaFxControllerFieldRef(XmlAttributeValue xmlAttributeValue, PsiMember fieldOrMethod, PsiClass aClass) {
            super((PsiElement)xmlAttributeValue, true);
            this.myXmlAttributeValue = xmlAttributeValue;
            this.myFieldOrMethod = fieldOrMethod;
            this.myAClass = aClass;
        }

        public XmlAttributeValue getXmlAttributeValue() {
            return this.myXmlAttributeValue;
        }

        public PsiClass getAClass() {
            return this.myAClass;
        }

        @Nullable
        public PsiElement resolve() {
            return this.myFieldOrMethod != null ? this.myFieldOrMethod : this.myXmlAttributeValue;
        }

        public boolean isUnresolved() {
            XmlFile xmlFile;
            return this.myFieldOrMethod == null && this.myAClass != null && (xmlFile = (XmlFile)this.myXmlAttributeValue.getContainingFile()).getRootTag() != null && !JavaFxPsiUtil.isOutOfHierarchy(this.myXmlAttributeValue);
        }

        @NotNull
        public Object[] getVariants() {
            PsiField[] fields;
            ArrayList<PsiField> fieldsToSuggest = new ArrayList<PsiField>();
            for (PsiField psiField : fields = this.myAClass.getFields()) {
                if (psiField.hasModifierProperty("static") || !JavaFxPsiUtil.isVisibleInFxml((PsiMember)psiField)) continue;
                fieldsToSuggest.add(psiField);
            }
            Object[] objectArray = ArrayUtil.toObjectArray(fieldsToSuggest);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxFieldIdReferenceProvider$JavaFxControllerFieldRef", "getVariants"));
            }
            return objectArray;
        }
    }
}

