/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLScalar;

public class YAMLScalarElementManipulator
extends AbstractElementManipulator<YAMLScalar> {
    @NotNull
    public TextRange getRangeInElement(@NotNull YAMLScalar element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/yaml/psi/impl/YAMLScalarElementManipulator", "getRangeInElement"));
        }
        String content = element.getText();
        int startOffset = content.startsWith("'") || content.startsWith("\"") ? 1 : 0;
        int endOffset = content.length() > 1 && (content.endsWith("'") || content.endsWith("\"")) ? -1 : 0;
        TextRange textRange = new TextRange(startOffset, content.length() + endOffset);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLScalarElementManipulator", "getRangeInElement"));
        }
        return textRange;
    }

    public YAMLScalar handleContentChange(@NotNull YAMLScalar element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/yaml/psi/impl/YAMLScalarElementManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "org/jetbrains/yaml/psi/impl/YAMLScalarElementManipulator", "handleContentChange"));
        }
        return element;
    }
}

