/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiTreeChangePreprocessorBase
implements PsiTreeChangePreprocessor {
    @NotNull
    private final Project myProject;
    @Nullable
    private final PsiManagerImpl myPsiManager;

    public PsiTreeChangePreprocessorBase(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/impl/PsiTreeChangePreprocessorBase", "<init>"));
        }
        this.myProject = project;
        this.myPsiManager = null;
    }

    public PsiTreeChangePreprocessorBase(@NotNull PsiManagerImpl psiManager) {
        if (psiManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiManager", "com/intellij/psi/impl/PsiTreeChangePreprocessorBase", "<init>"));
        }
        this.myPsiManager = psiManager;
        this.myProject = psiManager.getProject();
        psiManager.addTreeChangePreprocessor(this);
    }

    @Override
    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/psi/impl/PsiTreeChangePreprocessorBase", "treeChanged"));
        }
        boolean changedInsideCodeBlock = false;
        switch (event.getCode()) {
            case BEFORE_CHILDREN_CHANGE: {
                if (event.getParent() instanceof PsiFile) {
                    changedInsideCodeBlock = true;
                    break;
                }
            }
            case CHILDREN_CHANGED: {
                if (event.isGenericChange()) {
                    return;
                }
                changedInsideCodeBlock = this.isInsideCodeBlock(event.getParent());
                break;
            }
            case BEFORE_CHILD_ADDITION: 
            case BEFORE_CHILD_REMOVAL: 
            case CHILD_ADDED: 
            case CHILD_REMOVED: {
                changedInsideCodeBlock = this.isInsideCodeBlock(event.getParent());
                break;
            }
            case BEFORE_PROPERTY_CHANGE: 
            case PROPERTY_CHANGED: {
                changedInsideCodeBlock = false;
                break;
            }
            case BEFORE_CHILD_REPLACEMENT: 
            case CHILD_REPLACED: {
                changedInsideCodeBlock = this.isInsideCodeBlock(event.getParent());
                break;
            }
            case BEFORE_CHILD_MOVEMENT: 
            case CHILD_MOVED: {
                boolean bl = changedInsideCodeBlock = this.isInsideCodeBlock(event.getOldParent()) && this.isInsideCodeBlock(event.getNewParent());
            }
        }
        if (!changedInsideCodeBlock) {
            this.getModificationTracker().incOutOfCodeBlockModificationCounter();
        }
    }

    @NotNull
    private PsiModificationTrackerImpl getModificationTracker() {
        PsiModificationTrackerImpl psiModificationTrackerImpl = (PsiModificationTrackerImpl)ObjectUtils.notNull(this.myPsiManager, PsiManager.getInstance(this.myProject)).getModificationTracker();
        if (psiModificationTrackerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiTreeChangePreprocessorBase", "getModificationTracker"));
        }
        return psiModificationTrackerImpl;
    }

    protected abstract boolean isInsideCodeBlock(PsiElement var1);
}

