/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.AnnotationDeserializer$WhenMappings;
import org.jetbrains.kotlin.serialization.deserialization.FindClassInModuleKt;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J>\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0018\u00010\u00122\u0006\u0010\r\u001a\u00020\u00152\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00130\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u001c\u0010!\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\u0018H\u0002J\"\u0010$\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/AnnotationDeserializer;", "", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)V", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "factory", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValueFactory;", "deserializeAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "proto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Annotation;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "resolveArgument", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Annotation$Argument;", "parameterByName", "", "Lorg/jetbrains/kotlin/name/Name;", "resolveArrayElementType", "Lorg/jetbrains/kotlin/types/KotlinType;", "value", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Annotation$Argument$Value;", "resolveClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "resolveEnumValue", "enumClassId", "enumEntryName", "resolveValue", "expectedType", "kotlin-compiler"})
public final class AnnotationDeserializer {
    private final ConstantValueFactory factory;
    private final ModuleDescriptor module;

    private final KotlinBuiltIns getBuiltIns() {
        return this.module.getBuiltIns();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AnnotationDescriptor deserializeAnnotation(@NotNull ProtoBuf.Annotation proto, @NotNull NameResolver nameResolver) {
        ConstructorDescriptor constructor;
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        ClassId classId = nameResolver.getClassId(proto.getId());
        Intrinsics.checkExpressionValueIsNotNull(classId, "nameResolver.getClassId(proto.id)");
        ClassDescriptor annotationClass = this.resolveClass(classId);
        Map<ValueParameterDescriptor, ConstantValue<Object>> arguments2 = MapsKt.emptyMap();
        if (proto.getArgumentCount() != 0 && !ErrorUtils.isError(annotationClass) && DescriptorUtils.isAnnotationClass(annotationClass) && (constructor = (ConstructorDescriptor)CollectionsKt.singleOrNull((Iterable)annotationClass.getConstructors())) != null) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Object object;
            void var17_14;
            void destination$iv$iv2;
            Collection $receiver$iv$iv2;
            Iterable $receiver$iv;
            Iterable iterable = constructor.getValueParameters();
            int capacity$iv22 = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10)), 16);
            void var9_9 = $receiver$iv;
            Map map2 = new LinkedHashMap(capacity$iv22);
            for (Object element$iv$iv : $receiver$iv$iv2) {
                void it;
                ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)element$iv$iv;
                var17_14 = destination$iv$iv2;
                object = it.getName();
                var17_14.put(object, element$iv$iv);
            }
            void parameterByName = destination$iv$iv2;
            $receiver$iv = proto.getArgumentList();
            Iterable capacity$iv22 = $receiver$iv;
            $receiver$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Object element$iv$iv;
                element$iv$iv = (ProtoBuf.Annotation.Argument)item$iv$iv;
                var17_14 = destination$iv$iv;
                void v1 = it;
                Intrinsics.checkExpressionValueIsNotNull(v1, "it");
                object = this.resolveArgument((ProtoBuf.Annotation.Argument)v1, (Map<Name, ? extends ValueParameterDescriptor>)parameterByName, nameResolver);
                var17_14.add(object);
            }
            arguments2 = MapsKt.toMap(CollectionsKt.filterNotNull((List)destination$iv$iv));
        }
        return new AnnotationDescriptorImpl(annotationClass.getDefaultType(), arguments2, SourceElement.NO_SOURCE);
    }

    private final Pair<ValueParameterDescriptor, ConstantValue<?>> resolveArgument(ProtoBuf.Annotation.Argument proto, Map<Name, ? extends ValueParameterDescriptor> parameterByName, NameResolver nameResolver) {
        ValueParameterDescriptor valueParameterDescriptor = parameterByName.get(nameResolver.getName(proto.getNameId()));
        if (valueParameterDescriptor == null) {
            return null;
        }
        ValueParameterDescriptor parameter = valueParameterDescriptor;
        KotlinType kotlinType = parameter.getType();
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "parameter.type");
        ProtoBuf.Annotation.Argument.Value value = proto.getValue();
        Intrinsics.checkExpressionValueIsNotNull(value, "proto.value");
        return new Pair(parameter, this.resolveValue(kotlinType, value, nameResolver));
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final ConstantValue<?> resolveValue(@NotNull KotlinType expectedType, @NotNull ProtoBuf.Annotation.Argument.Value value, @NotNull NameResolver nameResolver) {
        Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
        Intrinsics.checkParameterIsNotNull(value, "value");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        v0 = value.getType();
        if (v0 == null) ** GOTO lbl-1000
        switch (AnnotationDeserializer$WhenMappings.$EnumSwitchMapping$0[v0.ordinal()]) {
            case 1: {
                v1 = this.factory.createByteValue((byte)value.getIntValue());
                break;
            }
            case 2: {
                v1 = this.factory.createCharValue((char)value.getIntValue());
                break;
            }
            case 3: {
                v1 = this.factory.createShortValue((short)value.getIntValue());
                break;
            }
            case 4: {
                v1 = this.factory.createIntValue((int)value.getIntValue());
                break;
            }
            case 5: {
                v1 = this.factory.createLongValue(value.getIntValue());
                break;
            }
            case 6: {
                v1 = this.factory.createFloatValue(value.getFloatValue());
                break;
            }
            case 7: {
                v1 = this.factory.createDoubleValue(value.getDoubleValue());
                break;
            }
            case 8: {
                v1 = this.factory.createBooleanValue(value.getIntValue() != 0L);
                break;
            }
            case 9: {
                v2 = nameResolver.getString(value.getStringValue());
                Intrinsics.checkExpressionValueIsNotNull(v2, "nameResolver.getString(value.stringValue)");
                v1 = this.factory.createStringValue(v2);
                break;
            }
            case 10: {
                var5_4 = "Class literal annotation arguments are not supported yet (" + nameResolver.getClassId(value.getClassId()) + ")";
                throw (Throwable)new IllegalStateException(message$iv.toString());
            }
            case 11: {
                v3 = nameResolver.getClassId(value.getClassId());
                Intrinsics.checkExpressionValueIsNotNull(v3, "nameResolver.getClassId(value.classId)");
                v4 = nameResolver.getName(value.getEnumValueId());
                Intrinsics.checkExpressionValueIsNotNull(v4, "nameResolver.getName(value.enumValueId)");
                v1 = this.resolveEnumValue(v3, v4);
                break;
            }
            case 12: {
                v5 = value.getAnnotation();
                Intrinsics.checkExpressionValueIsNotNull(v5, "value.annotation");
                v1 = new AnnotationValue(this.deserializeAnnotation(v5, nameResolver));
                break;
            }
            case 13: {
                expectedIsArray = KotlinBuiltIns.isArray(expectedType) != false || KotlinBuiltIns.isPrimitiveArray(expectedType) != false;
                arrayElements = value.getArrayElementList();
                var8_8 = arrayElements;
                if ($receiver$iv.isEmpty() == false) {
                    v6 = CollectionsKt.first(arrayElements);
                    Intrinsics.checkExpressionValueIsNotNull(v6, "arrayElements.first()");
                    actualElementType = this.resolveArrayElementType(v6, nameResolver);
                    v7 = this.getBuiltIns().getPrimitiveArrayKotlinTypeByPrimitiveKotlinType(actualElementType);
                    if (v7 == null) {
                        v7 = this.getBuiltIns().getArrayType(Variance.INVARIANT, actualElementType);
                    }
                } else if (expectedIsArray) {
                    v7 = expectedType;
                } else {
                    v8 = this.getBuiltIns().getArrayType(Variance.INVARIANT, this.getBuiltIns().getAnyType());
                    v7 = v8;
                    Intrinsics.checkExpressionValueIsNotNull(v8, "builtIns.getArrayType(Va\u2026T, builtIns.getAnyType())");
                }
                actualArrayType = v7;
                v9 = this.getBuiltIns();
                if (expectedIsArray) {
                    v10 = expectedType;
                } else {
                    v11 = actualArrayType;
                    v10 = v11;
                    Intrinsics.checkExpressionValueIsNotNull(v11, "actualArrayType");
                }
                expectedElementType = v9.getArrayElementType(v10);
                $i$f$isNotEmpty = arrayElements;
                var18_11 = this.factory;
                var10_12 = $receiver$iv;
                var11_13 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    var14_16 = (ProtoBuf.Annotation.Argument.Value)item$iv$iv;
                    var19_17 = destination$iv$iv;
                    v12 = expectedElementType;
                    Intrinsics.checkExpressionValueIsNotNull(v12, "expectedElementType");
                    v13 = it;
                    Intrinsics.checkExpressionValueIsNotNull(v13, "it");
                    var20_18 = this.resolveValue(v12, (ProtoBuf.Annotation.Argument.Value)v13, nameResolver);
                    var19_17.add(var20_18);
                }
                var19_17 = (List)destination$iv$iv;
                v14 = actualArrayType;
                Intrinsics.checkExpressionValueIsNotNull(v14, "actualArrayType");
                v1 = var18_11.createArrayValue(var19_17, v14);
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                expectedIsArray = "Unsupported annotation argument type: " + value.getType() + " (expected " + expectedType + ")";
                throw (Throwable)new IllegalStateException(message$iv.toString());
            }
        }
        result = v1;
        if (TypeUtilsKt.isSubtypeOf(result.getType(), expectedType)) {
            return result;
        }
        return this.factory.createErrorValue("Unexpected argument value");
    }

    private final ConstantValue<?> resolveEnumValue(ClassId enumClassId, Name enumEntryName) {
        ClassifierDescriptor enumEntry;
        ClassDescriptor enumClass = this.resolveClass(enumClassId);
        if (Intrinsics.areEqual((Object)enumClass.getKind(), (Object)ClassKind.ENUM_CLASS) && (enumEntry = enumClass.getUnsubstitutedInnerClassesScope().getContributedClassifier(enumEntryName, NoLookupLocation.FROM_DESERIALIZATION)) instanceof ClassDescriptor) {
            return this.factory.createEnumValue((ClassDescriptor)enumEntry);
        }
        return this.factory.createErrorValue("Unresolved enum entry: " + enumClassId + "." + enumEntryName);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final KotlinType resolveArrayElementType(ProtoBuf.Annotation.Argument.Value value, NameResolver nameResolver) {
        KotlinBuiltIns receiver$iv = this.getBuiltIns();
        KotlinBuiltIns $receiver = receiver$iv;
        ProtoBuf.Annotation.Argument.Value.Type type2 = value.getType();
        if (type2 != null) {
            switch (AnnotationDeserializer$WhenMappings.$EnumSwitchMapping$1[type2.ordinal()]) {
                case 1: {
                    KotlinType kotlinType = $receiver.getByteType();
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType, "getByteType()");
                    return kotlinType2;
                }
                case 2: {
                    KotlinType kotlinType = $receiver.getCharType();
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType, "getCharType()");
                    return kotlinType2;
                }
                case 3: {
                    KotlinType kotlinType = $receiver.getShortType();
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType, "getShortType()");
                    return kotlinType2;
                }
                case 4: {
                    KotlinType kotlinType = $receiver.getIntType();
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType, "getIntType()");
                    return kotlinType2;
                }
                case 5: {
                    KotlinType kotlinType = $receiver.getLongType();
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType, "getLongType()");
                    return kotlinType2;
                }
                case 6: {
                    KotlinType kotlinType = $receiver.getFloatType();
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType, "getFloatType()");
                    return kotlinType2;
                }
                case 7: {
                    KotlinType kotlinType = $receiver.getDoubleType();
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType, "getDoubleType()");
                    return kotlinType2;
                }
                case 8: {
                    KotlinType kotlinType = $receiver.getBooleanType();
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType, "getBooleanType()");
                    return kotlinType2;
                }
                case 9: {
                    KotlinType kotlinType = $receiver.getStringType();
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType, "getStringType()");
                    return kotlinType2;
                }
                case 10: {
                    void message$iv;
                    String string = "Arrays of class literals are not supported yet";
                    throw (Throwable)new IllegalStateException(message$iv.toString());
                }
                case 11: {
                    ClassId classId = nameResolver.getClassId(value.getClassId());
                    Intrinsics.checkExpressionValueIsNotNull(classId, "nameResolver.getClassId(value.classId)");
                    KotlinType kotlinType = this.resolveClass(classId).getDefaultType();
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType, "resolveClass(nameResolve\u2026lue.classId)).defaultType");
                    return kotlinType2;
                }
                case 12: {
                    ClassId classId = nameResolver.getClassId(value.getAnnotation().getId());
                    Intrinsics.checkExpressionValueIsNotNull(classId, "nameResolver.getClassId(value.annotation.id)");
                    KotlinType kotlinType = this.resolveClass(classId).getDefaultType();
                    KotlinType kotlinType2 = kotlinType;
                    Intrinsics.checkExpressionValueIsNotNull(kotlinType, "resolveClass(nameResolve\u2026notation.id)).defaultType");
                    return kotlinType2;
                }
                case 13: {
                    String message$iv = "Array of arrays is impossible";
                    throw (Throwable)new IllegalStateException(message$iv.toString());
                }
            }
        }
        String message$iv = "Unknown type: " + value.getType();
        throw (Throwable)new IllegalStateException(message$iv.toString());
    }

    private final ClassDescriptor resolveClass(ClassId classId) {
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(this.module, classId);
        if (classDescriptor == null) {
            ClassDescriptor classDescriptor2 = ErrorUtils.createErrorClass(classId.asSingleFqName().asString());
            classDescriptor = classDescriptor2;
            Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "ErrorUtils.createErrorCl\u2026ingleFqName().asString())");
        }
        return classDescriptor;
    }

    public AnnotationDeserializer(@NotNull ModuleDescriptor module) {
        Intrinsics.checkParameterIsNotNull(module, "module");
        this.module = module;
        this.factory = new ConstantValueFactory(this.getBuiltIns());
    }
}

