/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.ant.model.impl;

import com.intellij.lang.ant.config.impl.BuildFileProperty;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ant.model.JpsAntBuildFileOptions;
import org.jetbrains.jps.ant.model.impl.JpsAntInstallationImpl;

public class JpsAntBuildFileOptionsImpl
implements JpsAntBuildFileOptions {
    private int myMaxStackSize = 2;
    private String myAntCommandLineParameters = "";
    private int myMaxHeapSize = 128;
    private String myCustomJdkName = "";
    private boolean myUseProjectDefaultAnt = true;
    private String myAntInstallationName;
    private final List<String> myClasspath = new ArrayList<String>();
    private final List<String> myJarDirectories = new ArrayList<String>();
    private final List<BuildFileProperty> myProperties = new ArrayList<BuildFileProperty>();

    public void setMaxStackSize(int maxStackSize) {
        this.myMaxStackSize = maxStackSize;
    }

    @Override
    public void setAntCommandLineParameters(String antCommandLineParameters) {
        this.myAntCommandLineParameters = antCommandLineParameters;
    }

    @Override
    public void setUseProjectDefaultAnt(boolean useProjectDefaultAnt) {
        this.myUseProjectDefaultAnt = useProjectDefaultAnt;
    }

    @Override
    public String getAntInstallationName() {
        return this.myAntInstallationName;
    }

    public void setAntInstallationName(String antInstallationName) {
        this.myAntInstallationName = antInstallationName;
    }

    @Override
    public void addJarPath(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/jps/ant/model/impl/JpsAntBuildFileOptionsImpl", "addJarPath"));
        }
        this.myClasspath.add(path);
    }

    @Override
    public void addJarDirectory(@NotNull String directoryPath) {
        if (directoryPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryPath", "org/jetbrains/jps/ant/model/impl/JpsAntBuildFileOptionsImpl", "addJarDirectory"));
        }
        this.myJarDirectories.add(directoryPath);
    }

    public void setMaxHeapSize(int maxHeapSize) {
        this.myMaxHeapSize = maxHeapSize;
    }

    public void setCustomJdkName(String customJdkName) {
        this.myCustomJdkName = customJdkName;
    }

    @Override
    public int getMaxHeapSize() {
        return this.myMaxHeapSize;
    }

    @Override
    public int getMaxStackSize() {
        return this.myMaxStackSize;
    }

    @Override
    public String getCustomJdkName() {
        return this.myCustomJdkName;
    }

    @Override
    public String getAntCommandLineParameters() {
        return this.myAntCommandLineParameters;
    }

    @Override
    public boolean isUseProjectDefaultAnt() {
        return this.myUseProjectDefaultAnt;
    }

    @Override
    public List<String> getAdditionalClasspath() {
        return JpsAntInstallationImpl.getClasspath(this.myClasspath, this.myJarDirectories);
    }

    @Override
    public void addProperty(@NotNull String name, @NotNull String value) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/jps/ant/model/impl/JpsAntBuildFileOptionsImpl", "addProperty"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/jps/ant/model/impl/JpsAntBuildFileOptionsImpl", "addProperty"));
        }
        this.myProperties.add(new BuildFileProperty(name, value));
    }

    @Override
    @NotNull
    public List<BuildFileProperty> getProperties() {
        List<BuildFileProperty> list = this.myProperties;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/ant/model/impl/JpsAntBuildFileOptionsImpl", "getProperties"));
        }
        return list;
    }
}

