/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.bmp.pixelparsers;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.common.BinaryFileParser;
import org.apache.sanselan.formats.bmp.BmpHeaderInfo;

public abstract class PixelParser {
    public final BmpHeaderInfo bhi;
    public final byte[] colorTable;
    public final byte[] imageData;
    protected final BinaryFileParser bfp;
    protected final ByteArrayInputStream is;

    public PixelParser(BmpHeaderInfo bhi, byte[] ColorTable, byte[] ImageData) {
        this.bhi = bhi;
        this.colorTable = ColorTable;
        this.imageData = ImageData;
        this.bfp = new BinaryFileParser(73);
        this.is = new ByteArrayInputStream(ImageData);
    }

    public abstract void processImage(BufferedImage var1) throws ImageReadException, IOException;

    protected int getColorTableRGB(int index) {
        int blue = 0xFF & this.colorTable[(index *= 4) + 0];
        int green = 0xFF & this.colorTable[index + 1];
        int red = 0xFF & this.colorTable[index + 2];
        int alpha = 255;
        int rgb = alpha << 24 | red << 16 | green << 8 | blue << 0;
        return rgb;
    }
}

