/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sanselan.formats.tiff.write;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.sanselan.FormatCompliance;
import org.apache.sanselan.ImageReadException;
import org.apache.sanselan.ImageWriteException;
import org.apache.sanselan.common.BinaryFileFunctions;
import org.apache.sanselan.common.BinaryOutputStream;
import org.apache.sanselan.common.byteSources.ByteSource;
import org.apache.sanselan.common.byteSources.ByteSourceArray;
import org.apache.sanselan.formats.tiff.JpegImageData;
import org.apache.sanselan.formats.tiff.TiffContents;
import org.apache.sanselan.formats.tiff.TiffDirectory;
import org.apache.sanselan.formats.tiff.TiffElement;
import org.apache.sanselan.formats.tiff.TiffField;
import org.apache.sanselan.formats.tiff.TiffImageData;
import org.apache.sanselan.formats.tiff.TiffReader;
import org.apache.sanselan.formats.tiff.write.TiffImageWriterBase;
import org.apache.sanselan.formats.tiff.write.TiffImageWriterLossy;
import org.apache.sanselan.formats.tiff.write.TiffOutputDirectory;
import org.apache.sanselan.formats.tiff.write.TiffOutputItem;
import org.apache.sanselan.formats.tiff.write.TiffOutputSet;
import org.apache.sanselan.formats.tiff.write.TiffOutputSummary;
import org.apache.sanselan.util.Debug;

public class TiffImageWriterLossless
extends TiffImageWriterBase {
    private final byte[] exifBytes;
    private static final Comparator ELEMENT_SIZE_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            TiffElement e1 = (TiffElement)o1;
            TiffElement e2 = (TiffElement)o2;
            return e1.length - e2.length;
        }
    };
    private static final Comparator ITEM_SIZE_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            TiffOutputItem e1 = (TiffOutputItem)o1;
            TiffOutputItem e2 = (TiffOutputItem)o2;
            return e1.getItemLength() - e2.getItemLength();
        }
    };

    public TiffImageWriterLossless(byte[] exifBytes) {
        this.exifBytes = exifBytes;
    }

    public TiffImageWriterLossless(int byteOrder, byte[] exifBytes) {
        super(byteOrder);
        this.exifBytes = exifBytes;
    }

    private void dumpElements(List elements) throws IOException {
        ByteSourceArray byteSource = new ByteSourceArray(this.exifBytes);
        this.dumpElements(byteSource, elements);
    }

    private void dumpElements(ByteSource byteSource, List elements) throws IOException {
        int last = 8;
        for (int i = 0; i < elements.size(); ++i) {
            TiffElement element = (TiffElement)elements.get(i);
            if (element.offset > last) {
                int SLICE_SIZE = 32;
                int gepLength = element.offset - last;
                Debug.debug("gap of " + gepLength + " bytes.");
                byte[] bytes = byteSource.getBlock(last, gepLength);
                if (bytes.length > 64) {
                    Debug.debug("\thead", BinaryFileFunctions.head(bytes, 32));
                    Debug.debug("\ttail", BinaryFileFunctions.tail(bytes, 32));
                } else {
                    Debug.debug("\tbytes", bytes);
                }
            }
            Debug.debug("element[" + i + "]:" + element.getElementDescription() + " (" + element.offset + " + " + element.length + " = " + (element.offset + element.length) + ")");
            if (element instanceof TiffDirectory) {
                TiffDirectory dir = (TiffDirectory)element;
                Debug.debug("\tnext Directory Offset: " + dir.nextDirectoryOffset);
            }
            last = element.offset + element.length;
        }
        Debug.debug();
    }

    private List analyzeOldTiff() throws ImageWriteException, IOException {
        try {
            ByteSourceArray byteSource = new ByteSourceArray(this.exifBytes);
            Map params = null;
            FormatCompliance formatCompliance = FormatCompliance.getDefault();
            TiffContents contents = new TiffReader(false).readContents(byteSource, params, formatCompliance);
            ArrayList<TiffElement> elements = new ArrayList<TiffElement>();
            ArrayList directories = contents.directories;
            for (int d = 0; d < directories.size(); ++d) {
                TiffImageData tiffImageData;
                TiffDirectory directory = (TiffDirectory)directories.get(d);
                elements.add(directory);
                ArrayList fields = directory.getDirectoryEntrys();
                for (int f = 0; f < fields.size(); ++f) {
                    TiffField field = (TiffField)fields.get(f);
                    TiffElement oversizeValue = field.getOversizeValueElement();
                    if (oversizeValue == null) continue;
                    elements.add(oversizeValue);
                }
                JpegImageData jpegImageData = directory.getJpegImageData();
                if (jpegImageData != null) {
                    elements.add(jpegImageData);
                }
                if ((tiffImageData = directory.getTiffImageData()) == null) continue;
                TiffElement.DataElement[] data = tiffImageData.getImageData();
                for (int i = 0; i < data.length; ++i) {
                    elements.add(data[i]);
                }
            }
            Collections.sort(elements, TiffElement.COMPARATOR);
            ArrayList<TiffElement.Stub> result = new ArrayList<TiffElement.Stub>();
            int TOLERANCE = 3;
            TiffElement start = null;
            int index = -1;
            for (int i = 0; i < elements.size(); ++i) {
                TiffElement element = (TiffElement)elements.get(i);
                int lastElementByte = element.offset + element.length;
                if (start == null) {
                    start = element;
                    index = lastElementByte;
                    continue;
                }
                if (element.offset - index > 3) {
                    result.add(new TiffElement.Stub(start.offset, index - start.offset));
                    start = element;
                    index = lastElementByte;
                    continue;
                }
                index = lastElementByte;
            }
            if (null != start) {
                result.add(new TiffElement.Stub(start.offset, index - start.offset));
            }
            return result;
        }
        catch (ImageReadException e) {
            throw new ImageWriteException(e.getMessage(), e);
        }
    }

    @Override
    public void write(OutputStream os, TiffOutputSet outputSet) throws IOException, ImageWriteException {
        List analysis = this.analyzeOldTiff();
        int oldLength = this.exifBytes.length;
        if (analysis.size() < 1) {
            throw new ImageWriteException("Couldn't analyze old tiff data.");
        }
        if (analysis.size() == 1) {
            TiffElement onlyElement = (TiffElement)analysis.get(0);
            if (onlyElement.offset == 8 && onlyElement.offset + onlyElement.length + 8 == oldLength) {
                new TiffImageWriterLossy(this.byteOrder).write(os, outputSet);
                return;
            }
        }
        TiffOutputSummary outputSummary = this.validateDirectories(outputSet);
        List outputItems = outputSet.getOutputItems(outputSummary);
        int outputLength = this.updateOffsetsStep(analysis, outputItems);
        outputSummary.updateOffsets(this.byteOrder);
        this.writeStep(os, outputSet, analysis, outputItems, outputLength);
    }

    private int updateOffsetsStep(List analysis, List outputItems) throws IOException, ImageWriteException {
        int overflowIndex = this.exifBytes.length;
        ArrayList<TiffElement.Stub> unusedElements = new ArrayList<TiffElement.Stub>(analysis);
        Collections.sort(unusedElements, TiffElement.COMPARATOR);
        Collections.reverse(unusedElements);
        while (unusedElements.size() > 0) {
            TiffElement element = (TiffElement)unusedElements.get(0);
            int elementEnd = element.offset + element.length;
            if (elementEnd != overflowIndex) break;
            overflowIndex -= element.length;
            unusedElements.remove(0);
        }
        Collections.sort(unusedElements, ELEMENT_SIZE_COMPARATOR);
        Collections.reverse(unusedElements);
        ArrayList unplacedItems = new ArrayList(outputItems);
        Collections.sort(unplacedItems, ITEM_SIZE_COMPARATOR);
        Collections.reverse(unplacedItems);
        while (unplacedItems.size() > 0) {
            TiffOutputItem outputItem = (TiffOutputItem)unplacedItems.remove(0);
            int outputItemLength = outputItem.getItemLength();
            TiffElement bestFit = null;
            for (int i = 0; i < unusedElements.size(); ++i) {
                TiffElement element = (TiffElement)unusedElements.get(i);
                if (element.length < outputItemLength) break;
                bestFit = element;
            }
            if (null == bestFit) {
                outputItem.setOffset(overflowIndex);
                overflowIndex += outputItemLength;
                continue;
            }
            outputItem.setOffset(bestFit.offset);
            unusedElements.remove(bestFit);
            if (bestFit.length <= outputItemLength) continue;
            int excessOffset = bestFit.offset + outputItemLength;
            int excessLength = bestFit.length - outputItemLength;
            unusedElements.add(new TiffElement.Stub(excessOffset, excessLength));
            Collections.sort(unusedElements, ELEMENT_SIZE_COMPARATOR);
            Collections.reverse(unusedElements);
        }
        return overflowIndex;
    }

    private void writeStep(OutputStream os, TiffOutputSet outputSet, List analysis, List outputItems, int outputLength) throws IOException, ImageWriteException {
        int i;
        TiffOutputDirectory rootDirectory = outputSet.getRootDirectory();
        byte[] output = new byte[outputLength];
        System.arraycopy(this.exifBytes, 0, output, 0, Math.min(this.exifBytes.length, output.length));
        BufferOutputStream tos = new BufferOutputStream(output, 0);
        BinaryOutputStream bos = new BinaryOutputStream(tos, this.byteOrder);
        this.writeImageFileHeader(bos, rootDirectory.getOffset());
        for (i = 0; i < analysis.size(); ++i) {
            TiffElement element = (TiffElement)analysis.get(i);
            for (int j = 0; j < element.length; ++j) {
                int index = element.offset + j;
                if (index >= output.length) continue;
                output[index] = 0;
            }
        }
        for (i = 0; i < outputItems.size(); ++i) {
            TiffOutputItem outputItem = (TiffOutputItem)outputItems.get(i);
            BufferOutputStream tos2 = new BufferOutputStream(output, outputItem.getOffset());
            BinaryOutputStream bos2 = new BinaryOutputStream(tos2, this.byteOrder);
            outputItem.writeItem(bos2);
        }
        os.write(output);
    }

    private static class BufferOutputStream
    extends OutputStream {
        private final byte[] buffer;
        private int index;

        public BufferOutputStream(byte[] buffer, int index) {
            this.buffer = buffer;
            this.index = index;
        }

        @Override
        public void write(int b) throws IOException {
            if (this.index >= this.buffer.length) {
                throw new IOException("Buffer overflow.");
            }
            this.buffer[this.index++] = (byte)b;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (this.index + len > this.buffer.length) {
                throw new IOException("Buffer overflow.");
            }
            System.arraycopy(b, off, this.buffer, this.index, len);
            this.index += len;
        }
    }
}

