/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis;

import org.jacoco.asm.FieldVisitor;
import org.jacoco.core.analysis.IMethodCoverage;
import org.jacoco.core.internal.analysis.ClassCoverageImpl;
import org.jacoco.core.internal.analysis.MethodAnalyzer;
import org.jacoco.core.internal.analysis.StringPool;
import org.jacoco.core.internal.flow.ClassProbesVisitor;
import org.jacoco.core.internal.flow.MethodProbesVisitor;
import org.jacoco.core.internal.instr.InstrSupport;

public class ClassAnalyzer
extends ClassProbesVisitor {
    private final long classid;
    private final boolean noMatch;
    private final boolean[] probes;
    private final StringPool stringPool;
    private ClassCoverageImpl coverage;

    public ClassAnalyzer(long classid, boolean noMatch, boolean[] probes, StringPool stringPool) {
        this.classid = classid;
        this.noMatch = noMatch;
        this.probes = probes;
        this.stringPool = stringPool;
    }

    public ClassCoverageImpl getCoverage() {
        return this.coverage;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.coverage = new ClassCoverageImpl(this.stringPool.get(name), this.classid, this.noMatch, this.stringPool.get(signature), this.stringPool.get(superName), this.stringPool.get(interfaces));
    }

    public void visitSource(String source, String debug) {
        this.coverage.setSourceFileName(this.stringPool.get(source));
    }

    public MethodProbesVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        InstrSupport.assertNotInstrumented(name, this.coverage.getName());
        if (this.isMethodFiltered(access, name)) {
            return null;
        }
        return new MethodAnalyzer(this.stringPool.get(name), this.stringPool.get(desc), this.stringPool.get(signature), this.probes){

            public void visitEnd() {
                super.visitEnd();
                IMethodCoverage methodCoverage = this.getCoverage();
                if (methodCoverage.getInstructionCounter().getTotalCount() > 0) {
                    ClassAnalyzer.this.coverage.addMethod(methodCoverage);
                }
            }
        };
    }

    private boolean isMethodFiltered(int access, String name) {
        return (access & 0x1000) != 0 && !name.startsWith("lambda$");
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        InstrSupport.assertNotInstrumented(name, this.coverage.getName());
        return super.visitField(access, name, desc, signature, value);
    }

    public void visitTotalProbeCount(int count) {
    }
}

