/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.classworlds.launcher;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.launcher.ConfigurationException;
import org.codehaus.plexus.classworlds.launcher.ConfigurationHandler;
import org.codehaus.plexus.classworlds.launcher.ConfigurationParser;
import org.codehaus.plexus.classworlds.launcher.Launcher;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;

public class Configurator
implements ConfigurationHandler {
    private Launcher launcher;
    private ClassWorld world;
    private Map configuredRealms;
    private ClassRealm curRealm;
    private ClassLoader foreignClassLoader = null;

    public Configurator(Launcher launcher) {
        this.launcher = launcher;
        this.configuredRealms = new HashMap();
        if (launcher != null) {
            this.foreignClassLoader = launcher.getSystemClassLoader();
        }
    }

    public Configurator(ClassWorld world) {
        this.setClassWorld(world);
    }

    public void setClassWorld(ClassWorld world) {
        this.world = world;
        this.configuredRealms = new HashMap();
    }

    public void configure(InputStream is) throws IOException, ConfigurationException, DuplicateRealmException, NoSuchRealmException {
        if (this.world == null) {
            this.world = new ClassWorld();
        }
        this.curRealm = null;
        this.foreignClassLoader = null;
        if (this.launcher != null) {
            this.foreignClassLoader = this.launcher.getSystemClassLoader();
        }
        ConfigurationParser parser = new ConfigurationParser(this, System.getProperties());
        parser.parse(is);
        this.associateRealms();
        if (this.launcher != null) {
            this.launcher.setWorld(this.world);
        }
    }

    public void associateRealms() {
        ArrayList sortRealmNames = new ArrayList(this.configuredRealms.keySet());
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                String g1 = (String)o1;
                String g2 = (String)o2;
                return g1.compareTo(g2);
            }
        };
        Collections.sort(sortRealmNames, comparator);
        Iterator i = sortRealmNames.iterator();
        while (i.hasNext()) {
            String parentRealmName;
            ClassRealm parentRealm;
            String realmName = (String)i.next();
            int j = realmName.lastIndexOf(46);
            if (j <= 0 || (parentRealm = (ClassRealm)this.configuredRealms.get(parentRealmName = realmName.substring(0, j))) == null) continue;
            ClassRealm realm = (ClassRealm)this.configuredRealms.get(realmName);
            realm.setParentRealm(parentRealm);
        }
    }

    public void addImportFrom(String relamName, String importSpec) throws NoSuchRealmException {
        this.curRealm.importFrom(relamName, importSpec);
    }

    public void addLoadFile(File file) {
        try {
            this.curRealm.addURL(file.toURI().toURL());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public void addLoadURL(URL url) {
        this.curRealm.addURL(url);
    }

    public void addRealm(String realmName) throws DuplicateRealmException {
        this.curRealm = this.world.newRealm(realmName, this.foreignClassLoader);
        this.configuredRealms.put(realmName, this.curRealm);
    }

    public void setAppMain(String mainClassName, String mainRealmName) {
        if (this.launcher != null) {
            this.launcher.setAppMain(mainClassName, mainRealmName);
        }
    }
}

