/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepository;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnectionFactory;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;

public class DAVRepositoryFactory
extends SVNRepositoryFactory {
    private IHTTPConnectionFactory myConnectionFactory;

    public static void setup() {
        DAVRepositoryFactory.setup(IHTTPConnectionFactory.DEFAULT);
    }

    public static void setup(IHTTPConnectionFactory connectionFactory) {
        connectionFactory = connectionFactory == null ? IHTTPConnectionFactory.DEFAULT : connectionFactory;
        DAVRepositoryFactory factory = new DAVRepositoryFactory(connectionFactory);
        SVNRepositoryFactory.registerRepositoryFactory("^https?://.*$", factory);
    }

    private DAVRepositoryFactory(IHTTPConnectionFactory connectionFactory) {
        this.myConnectionFactory = connectionFactory;
    }

    @Override
    public SVNRepository createRepositoryImpl(SVNURL location, ISVNSession options) {
        return new DAVRepository(this.myConnectionFactory, location, options);
    }
}

