/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogDataKeys;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogDataProvider;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.data.VcsLogBranchFilterImpl;
import com.intellij.vcs.log.impl.VcsLogUtil;
import com.intellij.vcs.log.ui.filter.BranchPopupBuilder;
import git4idea.branch.DeepComparator;
import git4idea.repo.GitRepositoryManager;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DeepCompareAction
extends ToggleAction
implements DumbAware {
    public boolean isSelected(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        if (project == null || ui == null) {
            return false;
        }
        return DeepComparator.getInstance(project, ui).hasHighlightingOrInProgress();
    }

    public void setSelected(AnActionEvent e, boolean selected) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        final VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        final VcsLogDataProvider dataProvider = (VcsLogDataProvider)e.getData(VcsLogDataKeys.VCS_LOG_DATA_PROVIDER);
        if (project == null || ui == null || dataProvider == null) {
            return;
        }
        final DeepComparator dc = DeepComparator.getInstance(project, ui);
        if (selected) {
            String singleBranchName;
            VcsLogBranchFilter branchFilter = ui.getFilterUi().getFilters().getBranchFilter();
            String string = singleBranchName = branchFilter != null ? VcsLogUtil.getSingleFilteredBranch((VcsLogBranchFilter)branchFilter, (VcsLogRefs)ui.getDataPack().getRefs()) : null;
            if (singleBranchName == null) {
                DeepCompareAction.selectBranchAndPerformAction(ui.getDataPack(), e, new Consumer<String>(){

                    public void consume(String selectedBranch) {
                        ui.getFilterUi().setFilter((VcsLogFilter)VcsLogBranchFilterImpl.fromBranch((String)selectedBranch));
                        dc.highlightInBackground(selectedBranch, dataProvider);
                    }
                }, DeepCompareAction.getAllVisibleRoots(ui));
                return;
            }
            dc.highlightInBackground(singleBranchName, dataProvider);
        } else {
            dc.stopAndUnhighlight();
        }
    }

    private static void selectBranchAndPerformAction(@NotNull VcsLogDataPack dataPack, @NotNull AnActionEvent event, final @NotNull Consumer<String> consumer, @NotNull Collection<VirtualFile> visibleRoots) {
        if (dataPack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "git4idea/branch/DeepCompareAction", "selectBranchAndPerformAction"));
        }
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/branch/DeepCompareAction", "selectBranchAndPerformAction"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "git4idea/branch/DeepCompareAction", "selectBranchAndPerformAction"));
        }
        if (visibleRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleRoots", "git4idea/branch/DeepCompareAction", "selectBranchAndPerformAction"));
        }
        ActionGroup actionGroup = new BranchPopupBuilder(dataPack, visibleRoots, null){

            @NotNull
            protected AnAction createAction(final @NotNull String name) {
                if (name == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/branch/DeepCompareAction$2", "createAction"));
                }
                DumbAwareAction dumbAwareAction = new DumbAwareAction(name){

                    public void actionPerformed(AnActionEvent e) {
                        consumer.consume((Object)name);
                    }
                };
                if (dumbAwareAction == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/DeepCompareAction$2", "createAction"));
                }
                return dumbAwareAction;
            }
        }.build();
        ListPopup popup = JBPopupFactory.getInstance().createActionGroupPopup("Select branch to compare", actionGroup, event.getDataContext(), false, false, false, null, -1, null);
        InputEvent inputEvent = event.getInputEvent();
        if (inputEvent instanceof MouseEvent) {
            popup.show(new RelativePoint((MouseEvent)inputEvent));
        } else {
            popup.showInBestPositionFor(event.getDataContext());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "git4idea/branch/DeepCompareAction", "update"));
        }
        super.update(e);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VcsLogUi ui = (VcsLogUi)e.getData(VcsLogDataKeys.VCS_LOG_UI);
        e.getPresentation().setEnabledAndVisible(project != null && ui != null && DeepCompareAction.hasGitRoots(project, DeepCompareAction.getAllVisibleRoots(ui)));
    }

    private static boolean hasGitRoots(@NotNull Project project, @NotNull Set<VirtualFile> roots) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/branch/DeepCompareAction", "hasGitRoots"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "git4idea/branch/DeepCompareAction", "hasGitRoots"));
        }
        final GitRepositoryManager manager = (GitRepositoryManager)((Object)ServiceManager.getService((Project)project, GitRepositoryManager.class));
        return ContainerUtil.exists(roots, (Condition)new Condition<VirtualFile>(){

            public boolean value(VirtualFile root) {
                return manager.getRepositoryForRoot(root) != null;
            }
        });
    }

    @NotNull
    private static Set<VirtualFile> getAllVisibleRoots(@NotNull VcsLogUi ui) {
        if (ui == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ui", "git4idea/branch/DeepCompareAction", "getAllVisibleRoots"));
        }
        Set set = VcsLogUtil.getAllVisibleRoots(ui.getDataPack().getLogProviders().keySet(), (VcsLogRootFilter)ui.getFilterUi().getFilters().getRootFilter(), (VcsLogStructureFilter)ui.getFilterUi().getFilters().getStructureFilter());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/DeepCompareAction", "getAllVisibleRoots"));
        }
        return set;
    }
}

