/*
 * Decompiled with CFR 0.152.
 */
package git4idea.crlf;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import git4idea.crlf.GitCrlfUtil;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitCrlfDialog
extends DialogWrapper {
    public static final int SET = 0;
    public static final int DONT_SET = 2;
    public static final int CANCEL = 1;
    private JBCheckBox myDontWarn;

    public GitCrlfDialog(@Nullable Project project) {
        super(project, false);
        this.setOKButtonText("Fix and Commit");
        this.setCancelButtonText("Cancel");
        this.setTitle("Line Separators Warning");
        this.getCancelAction().putValue("FocusedAction", true);
        this.init();
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getHelpAction(), this.getOKAction(), this.getCancelAction(), new DialogWrapper.DialogWrapperExitAction((DialogWrapper)this, "Commit As Is", 2)};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/crlf/GitCrlfDialog", "createActions"));
        }
        return actionArray;
    }

    protected JComponent createCenterPanel() {
        JBLabel description = new JBLabel("<html>You are about to commit CRLF line separators to the Git repository.<br/>It is recommended to set core.autocrlf Git attribute to <code>" + GitCrlfUtil.RECOMMENDED_VALUE + "</code> to avoid line separator issues.</html>");
        JBLabel additionalDescription = new JBLabel("<html>Fix and Commit: <code>git config --global core.autocrlf " + GitCrlfUtil.RECOMMENDED_VALUE + "</code> will be called,<br/>" + "Commit as Is: the config value won't be set.</html>", UIUtil.ComponentStyle.SMALL);
        LinkLabel readMore = new LinkLabel("Read more", null, new LinkListener(){

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                BrowserUtil.browse((String)"https://help.github.com/articles/dealing-with-line-endings");
            }
        });
        JLabel icon = new JLabel(UIUtil.getWarningIcon(), 2);
        this.myDontWarn = new JBCheckBox("Don't warn again");
        this.myDontWarn.setMnemonic('w');
        JPanel rootPanel = new JPanel(new GridBagLayout());
        GridBag g = new GridBag().setDefaultInsets(new Insets(0, 6, 4, 10)).setDefaultAnchor(21).setDefaultFill(2);
        rootPanel.add((Component)icon, g.nextLine().next().coverColumn(4));
        rootPanel.add((Component)description, g.next());
        rootPanel.add((Component)readMore, g.nextLine().next().next());
        rootPanel.add((Component)additionalDescription, g.nextLine().next().next().pady(10));
        rootPanel.add((Component)this.myDontWarn, g.nextLine().next().next().insets(0, 0, 0, 0));
        return rootPanel;
    }

    public boolean dontWarnAgain() {
        return this.myDontWarn.isSelected();
    }

    @Nullable
    protected String getHelpId() {
        return "reference.VersionControl.Git.CrlfWarning";
    }
}

