/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import javax.xml.bind.annotation.XmlEnum;
import org.jetbrains.annotations.NotNull;
import org.tmatesoft.svn.core.SVNNodeKind;

@XmlEnum
public enum NodeKind {
    UNKNOWN("unknown"),
    FILE("file"),
    DIR("dir"),
    NONE("none");

    @NotNull
    private static final Map<String, NodeKind> ourAllNodeKinds;
    @NotNull
    private final String myKey;

    private NodeKind(String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/idea/svn/api/NodeKind", "<init>"));
        }
        this.myKey = key;
    }

    public boolean isFile() {
        return FILE.equals((Object)this);
    }

    public boolean isDirectory() {
        return DIR.equals((Object)this);
    }

    public boolean isNone() {
        return NONE.equals((Object)this);
    }

    public String toString() {
        return this.myKey;
    }

    private static void register(@NotNull NodeKind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/idea/svn/api/NodeKind", "register"));
        }
        ourAllNodeKinds.put(kind.myKey, kind);
    }

    @NotNull
    public static NodeKind from(@NotNull String nodeKindName) {
        if (nodeKindName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeKindName", "org/jetbrains/idea/svn/api/NodeKind", "from"));
        }
        NodeKind result = ourAllNodeKinds.get(nodeKindName);
        if (result == null) {
            throw new IllegalArgumentException("Unknown node kind " + nodeKindName);
        }
        NodeKind nodeKind = result;
        if (nodeKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/NodeKind", "from"));
        }
        return nodeKind;
    }

    @NotNull
    public static NodeKind from(@NotNull SVNNodeKind nodeKind) {
        if (nodeKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeKind", "org/jetbrains/idea/svn/api/NodeKind", "from"));
        }
        NodeKind nodeKind2 = NodeKind.from(nodeKind.toString());
        if (nodeKind2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/NodeKind", "from"));
        }
        return nodeKind2;
    }

    @NotNull
    public static NodeKind from(boolean isDirectory) {
        NodeKind nodeKind = isDirectory ? DIR : FILE;
        if (nodeKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/api/NodeKind", "from"));
        }
        return nodeKind;
    }

    static {
        ourAllNodeKinds = ContainerUtil.newHashMap();
        for (NodeKind kind : NodeKind.values()) {
            NodeKind.register(kind);
        }
    }
}

