/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.auth;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.IdeHttpClientHelpers;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.proxy.CommonProxy;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URL;
import java.security.KeyManagementException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.auth.AcceptResult;
import org.jetbrains.idea.svn.auth.CertificateTrustManager;
import org.jetbrains.idea.svn.auth.SSLServerCertificateAuthenticator;
import org.jetbrains.idea.svn.auth.SvnAuthenticationManager;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.SimpleCredentialsDialog;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.SVNAuthentication;

public class AuthenticationService {
    @NotNull
    private final SvnVcs myVcs;
    private final boolean myIsActive;
    private static final Logger LOG = Logger.getInstance(AuthenticationService.class);
    private File myTempDirectory;
    private boolean myProxyCredentialsWereReturned;
    private SvnConfiguration myConfiguration;
    private final Set<String> myRequestedCredentials;

    public AuthenticationService(@NotNull SvnVcs vcs, boolean isActive) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/auth/AuthenticationService", "<init>"));
        }
        this.myVcs = vcs;
        this.myIsActive = isActive;
        this.myConfiguration = SvnConfiguration.getInstance(this.myVcs.getProject());
        this.myRequestedCredentials = ContainerUtil.newHashSet();
    }

    @NotNull
    public SvnVcs getVcs() {
        SvnVcs svnVcs = this.myVcs;
        if (svnVcs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/auth/AuthenticationService", "getVcs"));
        }
        return svnVcs;
    }

    @Nullable
    public File getTempDirectory() {
        return this.myTempDirectory;
    }

    public boolean isActive() {
        return this.myIsActive;
    }

    @Nullable
    public SVNAuthentication requestCredentials(final SVNURL repositoryUrl, final String type) {
        SVNAuthentication authentication = null;
        if (repositoryUrl != null) {
            final String realm = repositoryUrl.toDecodedString();
            authentication = this.requestCredentials(realm, type, new Getter<SVNAuthentication>(){

                public SVNAuthentication get() {
                    return AuthenticationService.this.myVcs.getSvnConfiguration().getInteractiveManager(AuthenticationService.this.myVcs).getInnerProvider().requestClientAuthentication(type, repositoryUrl, realm, null, null, true);
                }
            });
        }
        if (authentication == null) {
            LOG.warn("Could not get authentication. Type - " + type + ", Url - " + repositoryUrl);
        }
        return authentication;
    }

    @Nullable
    private <T> T requestCredentials(@NotNull String realm, @NotNull String type, @NotNull Getter<T> fromUserProvider) {
        if (realm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "realm", "org/jetbrains/idea/svn/auth/AuthenticationService", "requestCredentials"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/idea/svn/auth/AuthenticationService", "requestCredentials"));
        }
        if (fromUserProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromUserProvider", "org/jetbrains/idea/svn/auth/AuthenticationService", "requestCredentials"));
        }
        Object result = null;
        Object data = SvnConfiguration.RUNTIME_AUTH_CACHE.getDataWithLowerCheck(type, realm);
        String key = SvnConfiguration.AuthStorage.getKey(type, realm);
        if (data != null && !this.myRequestedCredentials.contains(key)) {
            result = data;
            this.myRequestedCredentials.add(key);
        } else if (this.myIsActive && (result = fromUserProvider.get()) != null) {
            this.myVcs.getSvnConfiguration().acknowledge(type, realm, result);
            this.myRequestedCredentials.add(key);
        }
        return (T)result;
    }

    @Nullable
    public String requestSshCredentials(final @NotNull String realm, final @NotNull SimpleCredentialsDialog.Mode mode, final @NotNull String key) {
        if (realm == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "realm", "org/jetbrains/idea/svn/auth/AuthenticationService", "requestSshCredentials"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/idea/svn/auth/AuthenticationService", "requestSshCredentials"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/idea/svn/auth/AuthenticationService", "requestSshCredentials"));
        }
        return this.requestCredentials(realm, StringUtil.toLowerCase((String)mode.toString()), new Getter<String>(){

            public String get() {
                final Ref answer = new Ref();
                Runnable command = new Runnable(){

                    @Override
                    public void run() {
                        SimpleCredentialsDialog dialog = new SimpleCredentialsDialog(AuthenticationService.this.myVcs.getProject());
                        dialog.setup(mode, realm, key, true);
                        dialog.setTitle(SvnBundle.message("dialog.title.authentication.required", new Object[0]));
                        dialog.setSaveEnabled(false);
                        if (dialog.showAndGet()) {
                            answer.set((Object)dialog.getPassword());
                        }
                    }
                };
                WaitForProgressToShow.runOrInvokeAndWaitAboveProgress((Runnable)command, (ModalityState)ModalityState.any());
                return (String)answer.get();
            }
        });
    }

    @NotNull
    public AcceptResult acceptCertificate(@NotNull SVNURL url, @NotNull String certificateInfo) {
        AcceptResult result;
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/auth/AuthenticationService", "acceptCertificate"));
        }
        if (certificateInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "certificateInfo", "org/jetbrains/idea/svn/auth/AuthenticationService", "acceptCertificate"));
        }
        String kind = "terminal.ssl.server";
        String realm = url.toDecodedString();
        Object data = SvnConfiguration.RUNTIME_AUTH_CACHE.getDataWithLowerCheck(kind, realm);
        if (data != null) {
            result = (AcceptResult)((Object)data);
        } else {
            result = AcceptResult.from(this.getAuthenticationManager().getInnerProvider().acceptServerAuthentication(url, realm, (Object)certificateInfo, true));
            if (!AcceptResult.REJECTED.equals((Object)result)) {
                this.myVcs.getSvnConfiguration().acknowledge(kind, realm, (Object)result);
            }
        }
        AcceptResult acceptResult = result;
        if (acceptResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/auth/AuthenticationService", "acceptCertificate"));
        }
        return acceptResult;
    }

    public boolean acceptSSLServerCertificate(@Nullable SVNURL repositoryUrl, String realm) throws SvnBindException {
        boolean result;
        if (repositoryUrl == null) {
            return false;
        }
        if (Registry.is((String)"svn.use.svnkit.for.https.server.certificate.check")) {
            result = new SSLServerCertificateAuthenticator(this, repositoryUrl, realm).tryAuthenticate();
        } else {
            HttpClient client = this.getClient(repositoryUrl);
            try {
                client.execute((HttpUriRequest)new HttpGet(repositoryUrl.toDecodedString()));
                result = true;
            }
            catch (IOException e) {
                throw new SvnBindException(AuthenticationService.fixMessage(e), e);
            }
        }
        return result;
    }

    @Nullable
    private static String fixMessage(@NotNull IOException e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/svn/auth/AuthenticationService", "fixMessage"));
        }
        String message = null;
        if (e instanceof SSLHandshakeException) {
            if (StringUtil.containsIgnoreCase((String)e.getMessage(), (String)"received fatal alert: handshake_failure")) {
                message = e.getMessage() + ". Please try to specify SSL protocol manually - SSLv3 or TLSv1";
            } else if (e.getCause() != null) {
                message = e.getCause().getMessage();
            }
        }
        return message;
    }

    @NotNull
    private HttpClient getClient(@NotNull SVNURL repositoryUrl) {
        if (repositoryUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryUrl", "org/jetbrains/idea/svn/auth/AuthenticationService", "getClient"));
        }
        SSLContext sslContext = this.createSslContext(repositoryUrl);
        List<String> supportedProtocols = this.getSupportedSslProtocols();
        SSLConnectionSocketFactory socketFactory = new SSLConnectionSocketFactory(sslContext, ArrayUtil.toStringArray(supportedProtocols), null, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        if (this.haveDataForTmpConfig()) {
            IdeHttpClientHelpers.ApacheHttpClient4.setProxyIfEnabled((RequestConfig.Builder)requestConfigBuilder);
            IdeHttpClientHelpers.ApacheHttpClient4.setProxyCredentialsIfEnabled((CredentialsProvider)credentialsProvider);
        }
        CloseableHttpClient closeableHttpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)socketFactory).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(this.getAuthenticationManager().getReadTimeout(repositoryUrl)).build()).setDefaultRequestConfig(requestConfigBuilder.setConnectTimeout(this.getAuthenticationManager().getConnectTimeout(repositoryUrl)).build()).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        if (closeableHttpClient == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/auth/AuthenticationService", "getClient"));
        }
        return closeableHttpClient;
    }

    @NotNull
    private List<String> getSupportedSslProtocols() {
        ArrayList result = ContainerUtil.newArrayList();
        switch (this.myConfiguration.getSslProtocols()) {
            case sslv3: {
                result.add("SSLv3");
                break;
            }
            case tlsv1: {
                result.add("TLSv1");
                break;
            }
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/auth/AuthenticationService", "getSupportedSslProtocols"));
        }
        return arrayList;
    }

    @NotNull
    private SSLContext createSslContext(@NotNull SVNURL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/auth/AuthenticationService", "createSslContext"));
        }
        SSLContext result = CertificateManager.getSystemSslContext();
        CertificateTrustManager trustManager = new CertificateTrustManager(this, url);
        try {
            result.init(CertificateManager.getDefaultKeyManagers(), new TrustManager[]{trustManager}, null);
        }
        catch (KeyManagementException e) {
            LOG.error((Throwable)e);
        }
        SSLContext sSLContext = result;
        if (sSLContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/auth/AuthenticationService", "createSslContext"));
        }
        return sSLContext;
    }

    @NotNull
    public SvnAuthenticationManager getAuthenticationManager() {
        SvnAuthenticationManager svnAuthenticationManager = this.isActive() ? this.myConfiguration.getInteractiveManager(this.myVcs) : this.myConfiguration.getPassiveAuthenticationManager(this.myVcs.getProject());
        if (svnAuthenticationManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/auth/AuthenticationService", "getAuthenticationManager"));
        }
        return svnAuthenticationManager;
    }

    public void clearPassiveCredentials(String realm, SVNURL repositoryUrl, boolean password) {
        if (repositoryUrl == null) {
            return;
        }
        SvnConfiguration configuration = SvnConfiguration.getInstance(this.myVcs.getProject());
        List<String> kinds = AuthenticationService.getKinds(repositoryUrl, password);
        for (String kind : kinds) {
            configuration.clearCredentials(kind, realm);
        }
    }

    public boolean haveDataForTmpConfig() {
        HttpConfigurable instance = HttpConfigurable.getInstance();
        return SvnConfiguration.getInstance(this.myVcs.getProject()).isIsUseDefaultProxy() && (instance.USE_HTTP_PROXY || instance.USE_PROXY_PAC);
    }

    @Nullable
    public static Proxy getIdeaDefinedProxy(@NotNull SVNURL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/auth/AuthenticationService", "getIdeaDefinedProxy"));
        }
        CommonProxy.getInstance().removeNoProxy(url.getProtocol(), url.getHost(), url.getPort());
        List proxies = CommonProxy.getInstance().select(URI.create(url.toString()));
        if (proxies != null && !proxies.isEmpty()) {
            for (Proxy proxy : proxies) {
                if (!HttpConfigurable.isRealProxy((Proxy)proxy) || !Proxy.Type.HTTP.equals((Object)proxy.type())) continue;
                return proxy;
            }
        }
        return null;
    }

    @Nullable
    public PasswordAuthentication getProxyAuthentication(@NotNull SVNURL repositoryUrl) {
        if (repositoryUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryUrl", "org/jetbrains/idea/svn/auth/AuthenticationService", "getProxyAuthentication"));
        }
        Proxy proxy = AuthenticationService.getIdeaDefinedProxy(repositoryUrl);
        PasswordAuthentication result = null;
        if (proxy != null) {
            if (this.myProxyCredentialsWereReturned) {
                AuthenticationService.showFailedAuthenticateProxy();
            } else {
                result = AuthenticationService.getProxyAuthentication(proxy, repositoryUrl);
                this.myProxyCredentialsWereReturned = result != null;
            }
        }
        return result;
    }

    private static void showFailedAuthenticateProxy() {
        HttpConfigurable instance = HttpConfigurable.getInstance();
        String message = instance.USE_HTTP_PROXY || instance.USE_PROXY_PAC ? "Failed to authenticate to proxy. You can change proxy credentials in HTTP proxy settings." : "Failed to authenticate to proxy.";
        PopupUtil.showBalloonForActiveComponent((String)message, (MessageType)MessageType.ERROR);
    }

    @Nullable
    private static PasswordAuthentication getProxyAuthentication(@NotNull Proxy proxy, @NotNull SVNURL repositoryUrl) {
        if (proxy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proxy", "org/jetbrains/idea/svn/auth/AuthenticationService", "getProxyAuthentication"));
        }
        if (repositoryUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryUrl", "org/jetbrains/idea/svn/auth/AuthenticationService", "getProxyAuthentication"));
        }
        PasswordAuthentication result = null;
        try {
            result = Authenticator.requestPasswordAuthentication(repositoryUrl.getHost(), ((InetSocketAddress)proxy.address()).getAddress(), repositoryUrl.getPort(), repositoryUrl.getProtocol(), repositoryUrl.getHost(), repositoryUrl.getProtocol(), new URL(repositoryUrl.toString()), Authenticator.RequestorType.PROXY);
        }
        catch (MalformedURLException e) {
            LOG.info((Throwable)e);
        }
        return result;
    }

    public void reset() {
        if (this.myTempDirectory != null) {
            FileUtil.delete((File)this.myTempDirectory);
        }
    }

    @NotNull
    public static List<String> getKinds(SVNURL url, boolean passwordRequest) {
        if (passwordRequest || "http".equals(url.getProtocol())) {
            List<String> list = Collections.singletonList("svn.simple");
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/auth/AuthenticationService", "getKinds"));
            }
            return list;
        }
        if ("https".equals(url.getProtocol())) {
            List<String> list = Collections.singletonList("svn.ssl.client-passphrase");
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/auth/AuthenticationService", "getKinds"));
            }
            return list;
        }
        if ("svn".equals(url.getProtocol())) {
            List<String> list = Collections.singletonList("svn.simple");
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/auth/AuthenticationService", "getKinds"));
            }
            return list;
        }
        if (url.getProtocol().contains("svn+")) {
            List<String> list = Arrays.asList("svn.ssh", "svn.username");
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/auth/AuthenticationService", "getKinds"));
            }
            return list;
        }
        List<String> list = Collections.singletonList("svn.username");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/auth/AuthenticationService", "getKinds"));
        }
        return list;
    }

    @Nullable
    public File getSpecialConfigDir() {
        return this.myTempDirectory != null ? this.myTempDirectory : new File(this.myConfiguration.getConfigurationDirectory());
    }

    public void initTmpDir(SvnConfiguration configuration) throws IOException {
        if (this.myTempDirectory == null) {
            this.myTempDirectory = FileUtil.createTempDirectory((String)"tmp", (String)"Subversion");
            FileUtil.copyDir((File)new File(configuration.getConfigurationDirectory()), (File)this.myTempDirectory);
        }
    }
}

