/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SvnBranchConfiguration {
    private String myTrunkUrl;
    @NotNull
    private List<String> myBranchUrls;
    private boolean myUserinfoInUrl;

    public SvnBranchConfiguration() {
        this.myBranchUrls = new ArrayList<String>();
    }

    public SvnBranchConfiguration(String trunkUrl, @NotNull List<String> branchUrls, boolean userinfoInUrl) {
        if (branchUrls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchUrls", "org/jetbrains/idea/svn/branchConfig/SvnBranchConfiguration", "<init>"));
        }
        this.myTrunkUrl = trunkUrl;
        this.myBranchUrls = branchUrls;
        Collections.sort(this.myBranchUrls);
        this.myUserinfoInUrl = userinfoInUrl;
    }

    public boolean isUserinfoInUrl() {
        return this.myUserinfoInUrl;
    }

    public void setUserinfoInUrl(boolean userinfoInUrl) {
        this.myUserinfoInUrl = userinfoInUrl;
    }

    public void setBranchUrls(@NotNull List<String> branchUrls) {
        if (branchUrls == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchUrls", "org/jetbrains/idea/svn/branchConfig/SvnBranchConfiguration", "setBranchUrls"));
        }
        this.myBranchUrls = branchUrls;
        Collections.sort(this.myBranchUrls);
    }

    public void setTrunkUrl(String trunkUrl) {
        this.myTrunkUrl = trunkUrl;
    }

    public String getTrunkUrl() {
        return this.myTrunkUrl;
    }

    @NotNull
    public List<String> getBranchUrls() {
        List<String> list = this.myBranchUrls;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/branchConfig/SvnBranchConfiguration", "getBranchUrls"));
        }
        return list;
    }
}

