/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserComponent;
import org.jetbrains.idea.svn.dialogs.RepositoryBrowserDialog;
import org.jetbrains.idea.svn.dialogs.RepositoryTreeNode;
import org.jetbrains.idea.svn.dialogs.browser.UrlOpeningExpander;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;

public class SelectLocationDialog
extends DialogWrapper {
    private final Project myProject;
    private RepositoryBrowserComponent myRepositoryBrowser;
    private final SVNURL myURL;
    private final String myDstName;
    private final String myDstLabel;
    private JTextField myDstText;
    private final boolean myIsShowFiles;
    private final boolean myAllowActions;
    @NonNls
    private static final String HELP_ID = "vcs.subversion.common";

    @Nullable
    public static SVNURL selectLocation(Project project, String url) {
        SelectLocationDialog dialog = SelectLocationDialog.openDialog(project, url, null, null, true, false, null);
        return dialog == null || !dialog.isOK() ? null : dialog.getSelectedURL();
    }

    @Nullable
    public static Pair<SVNURL, SVNURL> selectLocation(Project project, @NotNull SVNURL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/dialogs/SelectLocationDialog", "selectLocation"));
        }
        SelectLocationDialog dialog = new SelectLocationDialog(project, url, null, null, true, true);
        return dialog.showAndGet() ? Pair.create((Object)dialog.getSelectedURL(), (Object)dialog.getRootUrl()) : null;
    }

    @Nullable
    public static String selectCopyDestination(Project project, String url, String dstLabel, String dstName, boolean showFiles) {
        SelectLocationDialog dialog = SelectLocationDialog.openDialog(project, url, dstLabel, dstName, showFiles, false, SvnBundle.message("select.location.invalid.url.message", url));
        return dialog == null || !dialog.isOK() ? null : SVNPathUtil.append((String)dialog.getSelectedURL().toString(), (String)dialog.getDestinationName());
    }

    @Nullable
    private static SelectLocationDialog openDialog(Project project, String url, String dstLabel, String dstName, boolean showFiles, boolean allowActions, String errorMessage) {
        try {
            SVNURL svnUrl = SvnUtil.createUrl(url);
            SVNURL repositoryUrl = SelectLocationDialog.initRoot(project, svnUrl);
            if (repositoryUrl == null) {
                Messages.showErrorDialog((Project)project, (String)("Can not detect repository root for URL: " + url), (String)SvnBundle.message("dialog.title.select.repository.location", new Object[0]));
                return null;
            }
            SelectLocationDialog dialog = new SelectLocationDialog(project, repositoryUrl, dstLabel, dstName, showFiles, allowActions);
            dialog.show();
            return dialog;
        }
        catch (SvnBindException e) {
            Messages.showErrorDialog((Project)project, (String)(errorMessage != null ? errorMessage : e.getMessage()), (String)SvnBundle.message("dialog.title.select.repository.location", new Object[0]));
            return null;
        }
    }

    private SelectLocationDialog(Project project, SVNURL url, String dstLabel, String dstName, boolean showFiles, boolean allowActions) {
        super(project, true);
        this.myProject = project;
        this.myDstLabel = dstLabel;
        this.myDstName = dstName;
        this.myURL = url;
        this.myIsShowFiles = showFiles;
        this.myAllowActions = allowActions;
        this.setTitle(SvnBundle.message("dialog.title.select.repository.location", new Object[0]));
        this.getHelpAction().setEnabled(true);
        this.init();
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp(HELP_ID);
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
        if (actionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/SelectLocationDialog", "createActions"));
        }
        return actionArray;
    }

    protected String getDimensionServiceKey() {
        return "svn.repositoryBrowser";
    }

    @Nullable
    private static SVNURL initRoot(final Project project, final SVNURL url) throws SvnBindException {
        final Ref result = new Ref();
        final Ref excRef = new Ref();
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                try {
                    result.set((Object)SvnUtil.getRepositoryRoot(SvnVcs.getInstance(project), url));
                }
                catch (SvnBindException e) {
                    excRef.set((Object)e);
                }
            }
        }, "Detecting repository root", true, project);
        if (!excRef.isNull()) {
            throw (SvnBindException)((Object)excRef.get());
        }
        return (SVNURL)result.get();
    }

    protected void init() {
        super.init();
        String urlString = this.myURL.toString();
        if (this.myAllowActions) {
            this.myRepositoryBrowser.setRepositoryURLs(new SVNURL[]{this.myURL}, this.myIsShowFiles, new UrlOpeningExpander.Factory(urlString, urlString), true);
        } else {
            this.myRepositoryBrowser.setRepositoryURL(this.myURL, this.myIsShowFiles, new UrlOpeningExpander.Factory(urlString, urlString));
        }
        this.myRepositoryBrowser.addChangeListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                SelectLocationDialog.this.getOKAction().setEnabled(SelectLocationDialog.this.isOKActionEnabled());
            }
        });
    }

    protected void dispose() {
        super.dispose();
        Disposer.dispose((Disposable)this.myRepositoryBrowser);
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JPanel browserPanel = new JPanel();
        browserPanel.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = new Insets(2, 2, 2, 2);
        gc.gridwidth = 2;
        gc.gridheight = 1;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 17;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        this.myRepositoryBrowser = new RepositoryBrowserComponent(SvnVcs.getInstance(this.myProject));
        browserPanel.add((Component)this.myRepositoryBrowser, gc);
        if (this.myDstName != null) {
            ++gc.gridy;
            gc.gridwidth = 1;
            gc.gridx = 0;
            gc.fill = 0;
            gc.weightx = 0.0;
            gc.weighty = 0.0;
            JLabel dstLabel = new JLabel(this.myDstLabel);
            browserPanel.add((Component)dstLabel, gc);
            ++gc.gridx;
            gc.weightx = 1.0;
            gc.fill = 2;
            this.myDstText = new JTextField();
            this.myDstText.setText(this.myDstName);
            this.myDstText.selectAll();
            browserPanel.add((Component)this.myDstText, gc);
            this.myDstText.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    SelectLocationDialog.this.getOKAction().setEnabled(SelectLocationDialog.this.isOKActionEnabled());
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    SelectLocationDialog.this.getOKAction().setEnabled(SelectLocationDialog.this.isOKActionEnabled());
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    SelectLocationDialog.this.getOKAction().setEnabled(SelectLocationDialog.this.isOKActionEnabled());
                }
            });
            dstLabel.setLabelFor(this.myDstText);
            gc.gridx = 0;
            ++gc.gridy;
            gc.gridwidth = 2;
            browserPanel.add((Component)new JSeparator(), gc);
        }
        if (this.myAllowActions) {
            panel.add((Component)this.createToolbar(), "North");
        }
        panel.add((Component)browserPanel, "Center");
        return panel;
    }

    @NotNull
    private JComponent createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new RepositoryBrowserDialog.EditLocationAction(this.myRepositoryBrowser));
        JComponent jComponent = ActionManager.getInstance().createActionToolbar("RepositoryBrowser.Toolbar", (ActionGroup)group, true).getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/dialogs/SelectLocationDialog", "createToolbar"));
        }
        return jComponent;
    }

    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.myRepositoryBrowser.getPreferredFocusedComponent();
    }

    public boolean shouldCloseOnCross() {
        return true;
    }

    public boolean isOKActionEnabled() {
        boolean ok;
        boolean bl = ok = this.myRepositoryBrowser.getSelectedURL() != null;
        if (ok && this.myDstText != null) {
            return this.myDstText.getText().trim().length() > 0;
        }
        return ok;
    }

    public String getDestinationName() {
        return SVNEncodingUtil.uriEncode((String)this.myDstText.getText().trim());
    }

    @Nullable
    public SVNURL getSelectedURL() {
        return this.myRepositoryBrowser.getSelectedSVNURL();
    }

    @Nullable
    public SVNURL getRootUrl() {
        RepositoryTreeNode node;
        for (node = this.myRepositoryBrowser.getSelectedNode(); node != null && node.getParent() instanceof RepositoryTreeNode; node = (RepositoryTreeNode)node.getParent()) {
        }
        return node != null ? node.getURL() : null;
    }
}

